/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ConcavePoleProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CantersPolyconic1989f9
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Canters Polyconic 1989-f9";
    public static final int PROPERTIES = 16;
    private static final double CX1 = 0.9305;
    private static final double CX2 = -0.1968;
    private static final double CX3 = -0.0067;
    private static final double CX4 = 0.0076;
    private static final double CY1 = 0.9305;
    private static final double CY2 = 0.0394;
    private static final double CY3 = 5.0E-4;
    private static final double CY4 = -0.0115;
    private static final double WIDTH_FACTOR = 2.9232519641653023;
    private static final double HEIGHT_FACTOR = 1.709051257002036;

    public CantersPolyconic1989f9(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPolyconic1989f9(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CantersPolyconic1989f9(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, 2.9232519641653023, 1.709051257002036);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad = CantersPolyconic1989f9.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * (0.9305 + phiRad2 * (-0.1968 + -0.0067 * lambdaRad2 + 0.0076 * phiRad2));
        double y = phiRad * (0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0115 * phiRad2));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad0;
        double lambdaRad0;
        double ya;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xa = Math.abs(x);
        double[] llRad = this.iterateRad(xa, ya = Math.abs(y), lambdaRad0 = 2.356194490192345, phiRad0 = ya < 1.4616259820826512 * this.rS_ ? ya * this.oneOverRS_ / 0.9305 : 1.5707863267948965);
        if (llRad == null) {
            return null;
        }
        double lambda = CantersPolyconic1989f9.toDegrees(llRad[0]);
        double phi = CantersPolyconic1989f9.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double lastLambdaRad = 0.0;
        double yy = 1.4616259820826512 * this.rS_;
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double lambdaRad;
            double phiRad;
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            if (y < yy) {
                phiRad = yOverRS / 0.9305;
                lambdaRad = 0.0;
            } else if (y > 0.5 * (yy + this.rS_ * 1.709051257002036)) {
                phiRad = 1.5707763267948966;
                lambdaRad = 2.356194490192345;
            } else {
                phiRad = 1.5707763267948966;
                lambdaRad = 0.0;
            }
            lastLambdaRad = 0.0;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double[] llRad = this.iterateRad(x, y, lambdaRad += 1.0E-5, phiRad);
                if (llRad == null) {
                    if (!(Math.abs(lastLambdaRad) > Math.PI)) continue;
                    continue block0;
                }
                lastLambdaRad = llRad[0];
                this.setQSymmetricPoints(ix, iy, CantersPolyconic1989f9.toDegrees(llRad[0]), CantersPolyconic1989f9.toDegrees(llRad[1]));
            }
        }
    }

    private double[] iterateRad(double x, double y, double lambdaRad0, double phiRad0) {
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        double yOverRS = y * this.oneOverRS_;
        double xOverRS = x * this.oneOverRS_;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double lambdaRad2 = lambdaRad * lambdaRad;
            double f1 = lambdaRad * (0.9305 + phiRad2 * (-0.1968 + -0.0067 * lambdaRad2 + 0.0076 * phiRad2)) - xOverRS;
            double f2 = phiRad * (0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0115 * phiRad2)) - yOverRS;
            double df1dPhi = lambdaRad * phiRad * (-0.3936 + -0.0134 * lambdaRad2 + 0.0304 * phiRad2);
            double df1dLambda = 0.9305 + phiRad2 * (-0.1968 + -0.0201 * lambdaRad2 + 0.0076 * phiRad2);
            double df2dPhi = 0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0345 * phiRad2);
            double df2dLambda = phiRad * lambdaRad * (0.0788 + 0.002 * lambdaRad + -0.023 * phiRad2);
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) break;
            ++iters;
        }
        if (iters >= 25) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

