/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class BreusingHarmonic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Breusing Harmonic";
    public static final int PROPERTIES = 131104;
    private static final double MAX_RADIUS = 180.0;
    private static final double DEFAULT_RADIUS = 90.0;
    private double radiusDeg_ = 90.0;
    private double radiusRad_;
    private double constB_;
    private double oneOverBRS_;
    private boolean fillCorners_;

    public BreusingHarmonic(int width, int height) {
        this(width, height, 0, 0);
    }

    public BreusingHarmonic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BreusingHarmonic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131104, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new DoubleParameter("Radius", "\u00b0", 90.0, 1.0E-4, 180.0, true, true));
        this.addParameter(new BooleanParameter("Fill corners", false));
        this.parameterChanged(null);
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            this.setRadius(((DoubleParameter)this.getParameter(0)).getValue());
            this.setFillCorners(((BooleanParameter)this.getParameter(1)).isSelected());
        } else if (p == this.getParameter(0)) {
            this.setRadius(((DoubleParameter)p).getValue());
        } else if (p == this.getParameter(1)) {
            this.setFillCorners(((BooleanParameter)p).isSelected());
        } else {
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    public void setRadius(double radius) {
        this.radiusDeg_ = radius;
        this.radiusRad_ = BreusingHarmonic.toRadians(radius);
        double halfBeta_ = 0.5 * this.radiusRad_;
        double quarterBeta_ = 0.25 * this.radiusRad_;
        double sinQuarterBeta = Math.sin(quarterBeta_);
        double tanQuarterBeta = Math.tan(quarterBeta_);
        double sin2QuarterBeta = sinQuarterBeta * sinQuarterBeta;
        double tan2QuarterBeta = tanQuarterBeta * tanQuarterBeta;
        double cosHalfBeta_ = Math.cos(halfBeta_);
        double secHalfBeta_ = 1.0 / cosHalfBeta_;
        double lnSecHalfBeta_ = Math.log(secHalfBeta_);
        this.constB_ = 4.0 * sin2QuarterBeta / (lnSecHalfBeta_ - tan2QuarterBeta);
        this.autoscale();
    }

    public void setFillCorners(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    protected void prepareScaling() {
        double z = this.radiusRad_;
        double quarterZ = 0.25 * z;
        double rhoMaxOverR = this.constB_ * Math.tan(quarterZ);
        this.setSizeFactors(rhoMaxOverR, rhoMaxOverR);
    }

    protected void finishScaling() {
        if (this.fillCorners_) {
            double quarterZ = 0.25 * Math.toRadians(180.0);
            double rhoBOverR = this.constB_ * Math.tan(quarterZ);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
        this.oneOverBRS_ = 1.0 / (this.constB_ * this.rS_);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = BreusingHarmonic.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == 1.0) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double z = Math.acos(cosZ);
        double quarterZ = 0.25 * z;
        double k = this.constB_ * Math.tan(quarterZ) / Math.sin(z);
        double x = k * cosPhi * Math.sin(lambdaRad);
        double rho2 = x * x + (y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda)) * y;
        if (rho2 * this.rS_ * this.rS_ > this.rhoBorder2_) {
            return null;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        if (!this.isWithinMargins(xx, yy)) {
            return null;
        }
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = 4.0 * Math.atan(rho * this.oneOverBRS_);
        if (Double.isNaN(z)) {
            return null;
        }
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phi = BreusingHarmonic.toDegrees(phiRad);
        double lambda = BreusingHarmonic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            double z = 1.0E-4;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double rho;
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > this.rhoBorder2_ || Double.isNaN(z = 4.0 * Math.atan((rho = Math.sqrt(rho2)) * this.oneOverBRS_))) continue;
                double sinZ = Math.sin(z);
                double cosZ = Math.cos(z);
                double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
                double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
                this.setBiSymmetricPoints(ix, iy, BreusingHarmonic.toDegrees(lambdaRad), BreusingHarmonic.toDegrees(phiRad));
            }
        }
    }
}

