/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class BraunStereographic
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Braun Stereographic";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 2.0;

    public BraunStereographic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BraunStereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, 2.0);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = BraunStereographic.toRadians(lat);
        double x = this.lon2LambdaRad(lon);
        double y = 2.0 * Math.tan(0.5 * phiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 2.0 * Math.atan2(yOverRS, 2.0);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phi = BraunStereographic.toDegrees(phiRad);
        double lambda = BraunStereographic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double yOverRS;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.0 * Math.atan2(yOverRS = (y = (double)iy + 0.5) * this.oneOverRS_, 2.0)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = BraunStereographic.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, BraunStereographic.toDegrees(lambdaRad), phi);
            }
        }
    }
}

