/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class BraunPerspective
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Braun Perspective";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 3.4999999999999996;

    public BraunPerspective(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BraunPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, 3.4999999999999996);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = BraunPerspective.toRadians(lat);
        double x = this.lon2LambdaRad(lon);
        double y = 1.4 * Math.sin(phiRad) / (0.4 + Math.cos(phiRad));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = 1.5707963267948966 * y / (double)this.yMax_;
        for (int iter = 0; iter < 25; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double func = 1.4 * this.rS_ * sinPhi - (0.4 + cosPhi) * y;
            double dfunc = 1.4 * this.rS_ * cosPhi + sinPhi * y;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phi = BraunPerspective.toDegrees(phiRad);
        double lambda = BraunPerspective.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double lambdaRad;
            double y = (double)iy + 0.5;
            for (int iter = 0; iter < 25; ++iter) {
                double sinPhi = Math.sin(phiRad);
                double cosPhi = Math.cos(phiRad);
                double func = 1.4 * this.rS_ * sinPhi - (0.4 + cosPhi) * y;
                double dfunc = 1.4 * this.rS_ * cosPhi + sinPhi * y;
                double dphiRad = -func / dfunc;
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = BraunPerspective.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, BraunPerspective.toDegrees(lambdaRad), phi);
            }
        }
    }
}

