/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ExtraParameter;

public class BooleanParameter
extends ExtraParameter {
    private boolean value_;
    private boolean defaultValue_;

    public BooleanParameter(String name, boolean value) {
        super(name, null);
        this.defaultValue_ = value;
        this.reset();
    }

    public void reset() {
        this.setSelected(this.defaultValue_);
    }

    public boolean getDefault() {
        return this.defaultValue_;
    }

    public boolean isSelected() {
        return this.value_;
    }

    public void setSelected(boolean value) {
        this.value_ = value;
        this.fireChange();
    }

    public Object getDefaultObject() {
        return this.defaultValue_;
    }

    public Object getValueObject() {
        return this.value_;
    }

    public void setValue(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        try {
            boolean b = Boolean.parseBoolean(value);
            this.setSelected(b);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a boolean: " + value);
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Value is not a Boolean.");
        }
        this.setSelected((Boolean)value);
    }
}

