/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Bonne
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Bonne";
    public static final int PROPERTIES = 256;
    private static final double DEFAULT_PHI1 = 50.0;
    private static final double WIDTH_FACTOR = Math.PI * 2;
    private static final double HEIGHT_FACTOR = Math.PI;
    private double phi1_ = 50.0;
    private double phi1Rad_;
    private double cotPhi1_;
    private Bezier[] curves = new Bezier[2];
    private double yShift_;
    private double lobeTipLat_;

    public Bonne(int width, int height) {
        this(width, height, 0, 0);
    }

    public Bonne(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Bonne(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 256, width, height, xmargin, ymargin, Math.PI * 2, Math.PI);
        this.addParameter(new DoubleParameter("Standard Lat.", "\u00b0", 50.0, -90.0, 90.0));
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(((DoubleParameter)p).getValue());
    }

    public void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Specified latitude out of valid range");
        }
        this.phi1_ = lat;
        if (this.phi1_ == 0.0) {
            this.phi1_ = 1.0E-6;
        }
        this.phi1Rad_ = Bonne.toRadians(this.phi1_);
        this.cotPhi1_ = 1.0 / Math.tan(this.phi1Rad_);
        this.autoscale();
    }

    protected void prepareScaling() {
        double yy;
        double latX = this.findLatitudeOfMaxX();
        double phiRad = Bonne.toRadians(latX);
        double rho = this.cotPhi1_ + this.phi1Rad_ - phiRad;
        double thetaRad = Math.PI * Math.cos(phiRad) / rho;
        double xMaxOverR = rho * Math.sin(thetaRad);
        double phiRad2 = this.phi1_ > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        double rho2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
        double y1 = this.cotPhi1_ - rho2;
        phiRad2 = this.phi1_ > 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        rho2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
        double y2 = this.cotPhi1_ - rho2;
        if (Math.abs(this.phi1_) > 12.0) {
            this.lobeTipLat_ = this.findLatitudeOfMaxY();
            phiRad2 = Bonne.toRadians(this.lobeTipLat_);
            rho2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
            double thetaRad2 = Math.PI * Math.cos(phiRad2) / rho2;
            yy = this.cotPhi1_ - rho2 * Math.cos(thetaRad2);
        } else {
            this.lobeTipLat_ = 0.0;
            yy = y1;
        }
        if (Math.abs(y1) > Math.abs(yy)) {
            yy = y1;
        }
        this.yShift_ = -0.5 * (yy + y2);
        double yMaxOverR = 0.5 * Math.abs(yy - y2);
        this.setSizeFactors(xMaxOverR, yMaxOverR);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        this.makeBezier();
        for (int i = 0; i < this.curves.length; ++i) {
            if (this.curves[i] == null) continue;
            this.curves[i].paint(g2d);
        }
    }

    private void makeBezier() {
        Vector<Point2D.Double> vector1 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector2 = new Vector<Point2D.Double>(100);
        int np = 60;
        double npfact = 3.0;
        double edgeLon = this.lambdaC_ + 180.0;
        for (int j = 0; j <= 60; ++j) {
            double lat = 90.0 - 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon - 0.001, lat);
            if (dot == null) continue;
            vector1.add(new Point2D.Double(dot.x, dot.y));
            vector2.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        }
        this.curves[0] = new Bezier(false, vector1);
        this.curves[1] = new Bezier(false, vector2);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Bonne.toRadians(lat);
        double rho = this.cotPhi1_ + this.phi1Rad_ - phiRad;
        if (Math.abs(rho) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.yShift_ * this.rS_);
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double thetaRad = lambdaRad * Math.cos(phiRad) / rho;
        double x = rho * Math.sin(thetaRad);
        double y = this.yShift_ + this.cotPhi1_ - rho * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double y1;
        double xOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
        double rho = pmFac * Math.hypot(xOverRS = x * this.oneOverRS_, y1 = this.cotPhi1_ - (yOverRS = y * this.oneOverRS_ - this.yShift_));
        double phiRad = this.cotPhi1_ + this.phi1Rad_ - rho;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
        double lambdaRad = thetaRad * rho / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Bonne.toDegrees(lambdaRad);
        double phi = Bonne.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
        block0: for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_ - this.yShift_;
            double y1 = this.cotPhi1_ - yOverRS;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                double rho = pmFac * Math.hypot(xOverRS, y1);
                double phiRad = this.cotPhi1_ + this.phi1Rad_ - rho;
                if (Math.abs(phiRad) > 1.5707963267948966) continue;
                double thetaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
                double lambdaRad = thetaRad * rho / Math.cos(phiRad);
                if (lambdaRad > Math.PI) {
                    if (!(Math.abs(this.phi1_) < 12.0)) continue;
                    continue block0;
                }
                this.setBiSymmetricPoints(ix, iy, Bonne.toDegrees(lambdaRad), Bonne.toDegrees(phiRad));
            }
        }
    }

    private double findLatitudeOfMaxX() {
        double phiRad = -Bonne.toRadians(45.0);
        if (this.phi1_ < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 25; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double rho = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            double thetaRad = Math.PI * cosPhi / rho;
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = (-Math.PI * sinPhi + thetaRad) / rho;
            double dsinTheta = cosTheta * dthetaRad;
            double dcosTheta = -sinTheta * dthetaRad;
            double func = sinTheta - rho * dsinTheta;
            double dfunc = dsinTheta - dcosTheta * (-Math.PI * sinPhi + thetaRad) - cosTheta * (-Math.PI * cosPhi + dthetaRad);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Bonne.toDegrees(phiRad);
    }

    private double findLatitudeOfMaxY() {
        double phiRad = Bonne.toRadians(45.0);
        if (this.phi1_ < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 25; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double rho = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            double thetaRad = Math.PI * cosPhi / rho;
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = (-Math.PI * sinPhi + thetaRad) / rho;
            double dsinTheta = cosTheta * dthetaRad;
            double dcosTheta = -sinTheta * dthetaRad;
            double func = cosTheta - rho * dcosTheta;
            double dfunc = dcosTheta + dsinTheta * (-Math.PI * sinPhi + thetaRad) + sinTheta * (-Math.PI * cosPhi + dthetaRad);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Bonne.toDegrees(phiRad);
    }
}

