/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class BoggsEumorphic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Boggs Eumorphic";
    private static final double TERM_K = 1.00138;
    private static final double TERM_L = 1.11072;
    private static final double TWO_K = 2.00276;
    private static final double ONE_OVER_TWO_K = 0.4993109508877749;
    private static final double ONE_PLUS_L = 2.1107199999999997;
    private static final double WIDTH_FACTOR = 2.980905142749154;
    private static final double HEIGHT_FACTOR = 1.4904481261698814;
    private double xFactor0_;

    public BoggsEumorphic(int width, int height) {
        this(width, height, 0, 0);
    }

    public BoggsEumorphic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BoggsEumorphic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 524292, width, height, xmargin, ymargin, 2.980905142749154, 1.4904481261698814);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.xFactor0_ = this.oneOverRS_ * 0.4993109508877749 * 2.1107199999999997;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.4904481261698814 * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.4904481261698814 * this.rS_);
        }
        double phiRad = BoggsEumorphic.toRadians(lat);
        double piSinPhi = Math.PI * Math.sin(phiRad);
        double thetaRad = BoggsEumorphic.toRadians(lat);
        for (int iter = 0; iter < 25; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = 0.4993109508877749 * (phiRad + 1.4142135623730951 * Math.sin(thetaRad));
        if (!this.isShowingInterrupted()) {
            x = 2.00276 * this.lon2LambdaRad(lon) / (1.0 / Math.cos(phiRad) + 1.11072 / Math.cos(thetaRad));
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = BoggsEumorphic.normalizeLon180(lon) - clon;
            if (BoggsEumorphic.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon) / 1.0539056102578441;
            x = cx + BoggsEumorphic.toRadians(dlon) * 2.00276 / (1.0 / Math.cos(phiRad) + 1.11072 / Math.cos(thetaRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double thetaRad = this.thetaRadForY(y);
        double phiRad = 2.00276 * y * this.oneOverRS_ - 1.4142135623730951 * Math.sin(thetaRad);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.oneOverRS_ * 0.4993109508877749 * (1.0 / Math.cos(phiRad) + 1.11072 / Math.cos(thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = BoggsEumorphic.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double thetaRad = this.thetaRadForY(y);
            double phiRad = 2.00276 * yOverRS - 1.4142135623730951 * Math.sin(thetaRad);
            if (phiRad < -1.5707963267948966) continue;
            if (phiRad > 1.5707963267948966) break;
            double phi = BoggsEumorphic.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ * 0.4993109508877749 * (1.0 / Math.cos(phiRad) + 1.11072 / Math.cos(thetaRad));
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }

    private double thetaRadForY(double y) {
        double twoKYOverR = 2.00276 * y * this.oneOverRS_;
        double thetaRad = (y > 0.0 ? 45.0 : -45.0) * (Math.PI / 180);
        for (int iter = 0; iter < 25; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double phiTerm = twoKYOverR - 1.4142135623730951 * Math.sin(thetaRad);
            double func = Math.sin(twoThetaRad) + twoThetaRad - Math.PI * Math.sin(phiTerm);
            double dfunc = 2.0 * Math.cos(twoThetaRad) + 2.0 + Math.PI * Math.cos(phiTerm) * 1.4142135623730951 * Math.cos(thetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        return thetaRad;
    }
}

