/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;

public abstract class BiSymmetricProjection
extends AbstractProjection {
    public BiSymmetricProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    protected void setBiSymmetricPoints(int ix, int iy, double lambda, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_ || colF < 0 || colF >= this.outWidth_) {
            return;
        }
        int indexR = row * this.outWidth_ + col;
        int indexL = row * this.outWidth_ + colF;
        this.invArrayLon_[indexR] = BiSymmetricProjection.normalizeLon360(this.lambdaC_ + lambda);
        this.invArrayLon_[indexL] = BiSymmetricProjection.normalizeLon360(this.lambdaC_ - lambda);
        this.invArrayLat_[indexR] = phi;
        this.invArrayLat_[indexL] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1) {
            int srcXF;
            int srcX = this.getSrcPixelX(this.lambdaC_ + lambda);
            if (srcX > -1) {
                this.invArray_[indexR] = srcY * this.srcWidth_ + srcX;
            }
            if ((srcXF = this.getSrcPixelX(this.lambdaC_ - lambda)) > -1) {
                this.invArray_[indexL] = srcY * this.srcWidth_ + srcXF;
            }
        }
    }
}

