/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class BakerDinomic
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Baker Dinomic";
    public static final int PROPERTIES = 262148;
    private static final double TWOSQRT2 = 2.8284271247461903;
    private static final double JOIN_LAT = 45.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 2.221441469079183;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private double joinY_;

    public BakerDinomic(int width, int height) {
        this(width, height, 0, 0);
    }

    public BakerDinomic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BakerDinomic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 262148, width, height, xmargin, ymargin, Math.PI, 2.221441469079183);
        this.autoscale();
    }

    protected void finishScaling() {
        Point2D.Double joinPt = this.transformLL2XYIgnoreMargins(0.0, 45.0);
        this.joinY_ = (double)this.outCenterY_ - joinPt.y;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = BakerDinomic.toRadians(lat);
        double x = 0.0;
        double y = 0.0;
        if (lat == 0.0) {
            x = this.lon2LambdaRad(lon);
        } else if (Math.abs(lat) <= 45.0) {
            x = this.lon2LambdaRad(lon);
            y = Math.log(Math.tan(0.5 * (1.5707963267948966 + phiRad)));
        } else {
            double absPhiRad = Math.abs(phiRad);
            y = 2.8284271247461903 * (absPhiRad - 0.7853981633974483) - Math.log(Math.tan(0.5 * absPhiRad));
            if (lat < 0.0) {
                y = -y;
            }
            x = this.lon2LambdaRad(lon) * Math.cos(absPhiRad) * (2.8284271247461903 - 1.0 / Math.sin(absPhiRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double absY = Math.abs(y);
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = absY * this.oneOverRS_;
        double lambdaRad = 0.0;
        double phiRad = 0.0;
        if (absY <= this.joinY_) {
            phiRad = 2.0 * Math.atan(Math.exp(yOverRS)) - 1.5707963267948966;
            lambdaRad = xOverRS;
        } else {
            phiRad = 0.7853981633974483;
            for (int iter = 0; iter < 25; ++iter) {
                double cosHalfPhi = Math.cos(0.5 * phiRad);
                double tanHalfPhi = Math.tan(0.5 * phiRad);
                double dphiRad = -(2.8284271247461903 * (phiRad - 0.7853981633974483) - Math.log(tanHalfPhi) - yOverRS) / (2.8284271247461903 - 0.5 * cosHalfPhi * cosHalfPhi / tanHalfPhi);
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            lambdaRad = xOverRS / (Math.cos(phiRad) * (2.8284271247461903 - 1.0 / Math.sin(phiRad)));
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        double lambda = BakerDinomic.toDegrees(lambdaRad);
        double phi = BakerDinomic.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double xOverRS;
            double x;
            double lambdaRad;
            int ix;
            double phi;
            double y = (double)iy + 0.5;
            if (y <= this.joinY_) {
                phiRad = 2.0 * Math.atan(Math.exp(y * this.oneOverRS_)) - 1.5707963267948966;
                phi = BakerDinomic.toDegrees(phiRad);
                for (ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_) > Math.PI); ++ix) {
                    this.setQSymmetricPoints(ix, iy, BakerDinomic.toDegrees(lambdaRad), phi);
                }
                continue;
            }
            double yOverRS = y * this.oneOverRS_;
            phiRad += 1.0E-5;
            for (int iter = 0; iter < 25; ++iter) {
                double cosHalfPhi = Math.cos(0.5 * phiRad);
                double tanHalfPhi = Math.tan(0.5 * phiRad);
                double dphiRad = -(2.8284271247461903 * (phiRad - 0.7853981633974483) - Math.log(tanHalfPhi) - yOverRS) / (2.8284271247461903 - 0.5 * cosHalfPhi * cosHalfPhi / tanHalfPhi);
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            phi = BakerDinomic.toDegrees(phiRad);
            double xFactor = 1.0 / (Math.cos(phiRad) * (2.8284271247461903 - 1.0 / Math.sin(phiRad)));
            for (ix = 0; ix < this.xMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.oneOverRS_) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, BakerDinomic.toDegrees(lambdaRad), phi);
            }
        }
    }
}

