/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class BaconGlobular
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Bacon Globular";
    private static final double TWO_OVER_PI = 0.6366197723675814;
    private static final double PI2_OVER_4 = 2.4674011002723395;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private BooleanParameter param0_ = new BooleanParameter("Global", true);
    private boolean global_ = true;

    public BaconGlobular(int width, int height) {
        this(width, height, 0, 0);
    }

    public BaconGlobular(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BaconGlobular(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.param0_);
    }

    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setGlobal(this.param0_.isSelected());
    }

    public void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    protected void prepareScaling() {
        if (this.global_) {
            this.setSizeFactors(Math.PI, 1.5707963267948966);
        } else {
            this.setSizeFactors(1.5707963267948966, 1.5707963267948966);
        }
    }

    protected void drawBorderLines(Graphics2D g2d) {
        if (this.global_) {
            super.drawBorderLines(g2d);
            return;
        }
        double r = Math.min(this.xMax_, this.yMax_);
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, r, r);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double add = this.global_ ? 180.0 : 90.0;
        double llon = this.lambdaC_ - add + 1.0E-4;
        double rlon = this.lambdaC_ + add - 1.0E-4;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null && dot2 == null) {
            return;
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo((float)dot1.x, (float)dot1.y);
        path.lineTo((float)dot2.x, (float)dot2.y);
        g2d.draw(path);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (!this.global_) {
            double diff;
            for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
            }
            while (diff < 0.0) {
                diff += 360.0;
            }
            if (Math.abs(diff - 90.0) < 1.0E-5 || Math.abs(diff - 270.0) < 1.0E-5) {
                return;
            }
        }
        super.drawMeridian(g2d, lon, label);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = BaconGlobular.toRadians(lat);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > Math.PI) {
            return null;
        }
        if (!this.global_ && absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double y = 1.5707963267948966 * Math.sin(phiRad);
        double x = 0.0;
        if (absLambdaRad != 0.0) {
            double f = 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad);
            x = absLambdaRad - f + Math.sqrt(f * f - y * y);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double y2OverR2S2 = yOverRS * yOverRS;
        double phiRad = Math.asin(2.0 * yOverRS / Math.PI);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = 0.0;
        if (x != 0.0) {
            double xOverRS = Math.abs(x) * this.oneOverRS_;
            lambdaRad = Math.abs(phiRad) < 1.5707963267948966 ? 0.7853981633974483 : 2.356194490192345;
            for (int iter = 0; iter < 25; ++iter) {
                double lambdaRad2 = lambdaRad * lambdaRad;
                double f = 0.5 * (lambdaRad + 2.4674011002723395 / lambdaRad);
                double sqrtTerm = Math.sqrt(f * f - y2OverR2S2);
                double dfDLambda = 0.5 * (1.0 - 2.4674011002723395 / lambdaRad2);
                double func = lambdaRad - f + sqrtTerm - xOverRS;
                double dfunc = 1.0 - dfDLambda + f * dfDLambda / sqrtTerm;
                double dlambdaRad = -func / dfunc;
                lambdaRad += dlambdaRad;
                if (Math.abs(dlambdaRad) < 1.0E-5) break;
            }
            if (lambdaRad > Math.PI) {
                return null;
            }
            if (!this.global_ && lambdaRad > 1.5707963267948966) {
                return null;
            }
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
        }
        double phi = BaconGlobular.toDegrees(phiRad);
        double lambda = BaconGlobular.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double yOverRS;
        double phiRad;
        block0: for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin((yOverRS = (y = (double)iy + 0.5) * this.oneOverRS_) * 0.6366197723675814)) > 1.5707963267948966); ++iy) {
            double phi = BaconGlobular.toDegrees(phiRad);
            double y2OverR2S2 = yOverRS * yOverRS;
            double lambdaRad = phi < 90.0 ? 1.0E-5 : 1.5708063267948966;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                for (int iter = 0; iter < 25; ++iter) {
                    double lambdaRad2 = lambdaRad * lambdaRad;
                    double f = 0.5 * (lambdaRad + 2.4674011002723395 / lambdaRad);
                    double sqrtTerm = Math.sqrt(f * f - y2OverR2S2);
                    double dfDLambda = 0.5 * (1.0 - 2.4674011002723395 / lambdaRad2);
                    double func = lambdaRad - f + sqrtTerm - xOverRS;
                    double dfunc = 1.0 - dfDLambda + f * dfDLambda / sqrtTerm;
                    double dlambdaRad = -func / dfunc;
                    lambdaRad += dlambdaRad;
                    if (Math.abs(dlambdaRad) < 1.0E-5) break;
                }
                if (lambdaRad > Math.PI || !this.global_ && lambdaRad > 1.5707963267948966) continue block0;
                this.setQSymmetricPoints(ix, iy, BaconGlobular.toDegrees(lambdaRad), phi);
            }
        }
    }
}

