/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public abstract class AzimuthalProjection
extends BiSymmetricProjection {
    protected static final double MIN_RADIUS = 1.0E-4;
    protected double rhoBorder_;
    protected double rhoBorder2_;
    private Arc2D.Double arc_ = new Arc2D.Double();
    protected double cosPhiC_;
    protected double sinPhiC_;

    public AzimuthalProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
        this.setCenter(this.lambdaC_, this.phiC_);
    }

    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(AzimuthalProjection.toRadians(this.phiC_));
        this.sinPhiC_ = Math.sin(AzimuthalProjection.toRadians(this.phiC_));
    }

    protected void drawBorderLines(Graphics2D g2d) {
        this.drawCircle(g2d, this.rhoBorder_, true);
    }

    private void drawCircle(Graphics2D g2d, double radius, boolean link) {
        double r2 = radius * radius;
        double w2 = this.xMax_ * this.xMax_;
        double h2 = this.yMax_ * this.yMax_;
        double rhoCorner = Math.sqrt(w2 + h2);
        g2d.translate(this.outCenterX_, this.outCenterY_);
        if (radius <= (double)this.xMax_ && radius <= (double)this.yMax_) {
            ProjectionUtils.drawEllipse(g2d, 0, 0, radius, radius);
        } else if (radius > rhoCorner) {
            Path2D.Double path = new Path2D.Double();
            path.moveTo(-((float)this.xMax_), -((float)this.yMax_));
            path.lineTo(this.xMax_, -((float)this.yMax_));
            path.lineTo(this.xMax_, this.yMax_);
            path.lineTo(-((float)this.xMax_), this.yMax_);
            path.closePath();
            g2d.draw(path);
        } else if (radius > (double)this.xMax_ && radius > (double)this.yMax_) {
            double dxx = Math.sqrt(r2 - h2);
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-((float)dxx), -((float)this.yMax_));
                path.lineTo((float)dxx, -((float)this.yMax_));
                path.moveTo(this.xMax_, -((float)dyy));
                path.lineTo(this.xMax_, (float)dyy);
                path.moveTo((float)dxx, this.yMax_);
                path.lineTo(-((float)dxx), this.yMax_);
                path.moveTo(-((float)this.xMax_), (float)dyy);
                path.lineTo(-((float)this.xMax_), -((float)dyy));
                g2d.draw(path);
            }
            double angle1 = -Math.acos(dxx / radius) * 57.29577951308232;
            double angle2 = 90.0 - Math.acos(dyy / radius) * 57.29577951308232;
            double arc = Math.abs(angle1 + angle2);
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle1, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, -angle1, -arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle1, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 - angle1, -arc, 0);
            g2d.draw(this.arc_);
        } else if (radius > (double)this.yMax_) {
            double dxx = Math.sqrt(r2 - h2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-((float)dxx), -((float)this.yMax_));
                path.lineTo((float)dxx, -((float)this.yMax_));
                path.moveTo((float)dxx, this.yMax_);
                path.lineTo(-((float)dxx), this.yMax_);
                g2d.draw(path);
            }
            double angle = -Math.acos(dxx / radius) * 57.29577951308232;
            double arc = -2.0 * angle;
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, arc, 0);
            g2d.draw(this.arc_);
        } else if (radius > (double)this.xMax_) {
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-((float)this.xMax_), -((float)dyy));
                path.lineTo(-((float)this.xMax_), (float)dyy);
                path.moveTo(this.xMax_, (float)dyy);
                path.lineTo(this.xMax_, -((float)dyy));
                g2d.draw(path);
            }
            double angle = 90.0 - Math.acos(dyy / radius) * 57.29577951308232;
            double arc = 180.0 - 2.0 * angle;
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, arc, 0);
            g2d.draw(this.arc_);
        }
        g2d.translate(-this.outCenterX_, -this.outCenterY_);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (this.phiC_ == 90.0 || this.phiC_ == -90.0) {
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
            if (dot == null) {
                return;
            }
            double r = Math.abs((double)this.outCenterY_ - dot.y);
            this.drawCircle(g2d, r, false);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (this.phiC_ == 90.0 || this.phiC_ == -90.0) {
            Point2D.Double dot;
            Point2D.Double double_ = dot = this.phiC_ > 0.0 ? this.transformLL2XYIgnoreMargins(lon, 80.0) : this.transformLL2XYIgnoreMargins(lon, -85.0);
            if (dot == null) {
                return;
            }
            double dx = dot.x - (double)this.outCenterX_;
            double dy = dot.y - (double)this.outCenterY_;
            double r = Math.sqrt(dx * dx + dy * dy);
            double ratio = this.rhoBorder_ / r;
            dx *= ratio;
            dy *= ratio;
            if (Math.abs(dx) > (double)this.xMax_) {
                ratio = Math.abs((double)this.xMax_ / dx);
                dx *= ratio;
                dy *= ratio;
            }
            if (Math.abs(dy) > (double)this.yMax_) {
                ratio = Math.abs((double)this.yMax_ / dy);
                dx *= ratio;
                dy *= ratio;
            }
            GraphicUtilities.drawLine(g2d, (double)this.outCenterX_, (double)this.outCenterY_, (double)this.outCenterX_ + dx, (double)this.outCenterY_ + dy);
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }
}

