/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Apian2
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Apian II";
    private static final double ONE_OVER_PI = 0.3183098861837907;
    private static final double PI2_OVER_4 = 2.4674011002723395;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private BooleanParameter param0_ = new BooleanParameter("Global", true);
    private boolean global_ = true;

    public Apian2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Apian2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Apian2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.param0_);
    }

    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setGlobal(this.param0_.isSelected());
    }

    public void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    protected void prepareScaling() {
        if (this.global_) {
            this.setSizeFactors(Math.PI, 1.5707963267948966);
        } else {
            this.setSizeFactors(1.5707963267948966, 1.5707963267948966);
        }
    }

    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (!this.global_) {
            double diff;
            for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
            }
            while (diff < 0.0) {
                diff += 360.0;
            }
            if (Math.abs(diff - 90.0) < 1.0E-5 || Math.abs(diff - 270.0) < 1.0E-5) {
                return;
            }
        }
        super.drawMeridian(g2d, lon, label);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Apian2.toRadians(lat);
        double lambdaRad = this.lon2LambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > Math.PI) {
            return null;
        }
        if (!this.global_ && absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double x = 0.3183098861837907 * lambdaRad * Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * Math.PI * this.oneOverRS_ / Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (!this.global_ && Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phi = Apian2.toDegrees(phiRad);
        double lambda = Apian2.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Apian2.toDegrees(phiRad);
            double xFactor = Math.PI * this.oneOverRS_ / Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
            for (int ix = 0; !(ix >= this.xMax_ || (lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI || !this.global_ && lambdaRad > 1.5707963267948966); ++ix) {
                this.setQSymmetricPoints(ix, iy, Apian2.toDegrees(lambdaRad), phi);
            }
        }
    }
}

