/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ConicProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AlbersEqualAreaConic
extends ConicProjection {
    public static final String PROJECTION_NAME = "Albers Equal-Area Conic";
    public static final int PROPERTIES = 131080;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double termN_;
    private double twoN_;
    private double oneOverN_;
    private double termC_;
    private double rho0_;

    public AlbersEqualAreaConic(int width, int height) {
        this(width, height, 0, 0);
    }

    public AlbersEqualAreaConic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AlbersEqualAreaConic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131080, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.autoscale();
    }

    protected void prepareScaling() {
        double phi1Rad = AlbersEqualAreaConic.toRadians(this.phi1_);
        double phi2Rad = AlbersEqualAreaConic.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double sinPhiC = Math.sin(AlbersEqualAreaConic.toRadians(this.phiC_));
        double sinPhi1 = Math.sin(phi1Rad);
        double sinPhi2 = Math.sin(phi2Rad);
        this.termN_ = 0.5 * (sinPhi1 + sinPhi2);
        this.twoN_ = 2.0 * this.termN_;
        this.oneOverN_ = 1.0 / this.termN_;
        this.termC_ = cosPhi1 * cosPhi1 + this.twoN_ * sinPhi1;
        this.rho0_ = Math.sqrt(this.termC_ - this.twoN_ * sinPhiC) * this.oneOverN_;
        double dPhi = this.phiHeight_;
        double phiTRad = Math.min(90.0, this.phiC_ + 0.5 * dPhi) * (Math.PI / 180);
        double phiBRad = Math.max(-90.0, this.phiC_ - 0.5 * dPhi) * (Math.PI / 180);
        double sinPhiT = Math.sin(phiTRad);
        double sinPhiB = Math.sin(phiBRad);
        double lambdaRad1 = 0.0;
        double lambdaRad2 = 0.5 * AlbersEqualAreaConic.toRadians(dPhi);
        double rhoT = Math.sqrt(this.termC_ - this.twoN_ * sinPhiT) * this.oneOverN_;
        double rhoB = Math.sqrt(this.termC_ - this.twoN_ * sinPhiB) * this.oneOverN_;
        double theta1 = this.termN_ * 0.0;
        double theta2 = this.termN_ * lambdaRad2;
        double xT1 = rhoT * Math.sin(theta1);
        double xT2 = rhoT * Math.sin(theta2);
        double xB1 = rhoB * Math.sin(theta1);
        double xB2 = rhoB * Math.sin(theta2);
        double yT1 = this.rho0_ - rhoT * Math.cos(theta1);
        double yT2 = this.rho0_ - rhoT * Math.cos(theta2);
        double yB1 = this.rho0_ - rhoB * Math.cos(theta1);
        double yB2 = this.rho0_ - rhoB * Math.cos(theta2);
        double yT = yT2 > yB2 ? Math.max(yT1, yT2) : Math.max(yT1, yB2);
        double yB = yT2 > yB2 ? Math.min(yB1, yB2) : Math.min(yB1, yT2);
        double xMaxOverR = Math.max(xT2, xB2);
        double yMaxOverR = Math.max(Math.abs(yT), Math.abs(yB));
        this.setSizeFactors(xMaxOverR, yMaxOverR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = AlbersEqualAreaConic.toRadians(lat);
        double rho = Math.sqrt(this.termC_ - this.twoN_ * Math.sin(phiRad)) * this.oneOverN_;
        double theta = this.termN_ * lambdaRad;
        double x = rho * Math.sin(theta);
        double y = this.rho0_ - rho * Math.cos(theta);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double rho0MinusYOverRS = this.rho0_ - yOverRS;
        double rho = Math.hypot(xOverRS, rho0MinusYOverRS);
        double nRho = this.termN_ * rho;
        double phiRad = Math.asin(0.5 * (this.termC_ - nRho * nRho) * this.oneOverN_);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double theta = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0MinusYOverRS) : Math.atan2(xOverRS, rho0MinusYOverRS);
        double lambdaRad = theta * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = AlbersEqualAreaConic.toDegrees(phiRad);
        double lambda = AlbersEqualAreaConic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double rho0MinusYOverRS = this.rho0_ - yOverRS;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                double rho = Math.hypot(xOverRS, rho0MinusYOverRS);
                double nRho = this.termN_ * rho;
                double sinPhi = 0.5 * (this.termC_ - nRho * nRho) * this.oneOverN_;
                if (Math.abs(sinPhi) > 1.0) continue;
                double phiRad = Math.asin(sinPhi);
                double theta = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0MinusYOverRS) : Math.atan2(xOverRS, rho0MinusYOverRS);
                double lambdaRad = theta * this.oneOverN_;
                if (lambdaRad > Math.PI) continue;
                this.setBiSymmetricPoints(ix, iy, AlbersEqualAreaConic.toDegrees(lambdaRad), AlbersEqualAreaConic.toDegrees(phiRad));
            }
        }
    }
}

