/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.EllipseProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Aitoff
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Aitoff";
    public static final int PROPERTIES = 16;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public Aitoff(int width, int height) {
        this(width, height, 0, 0);
    }

    public Aitoff(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Aitoff(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 0.0) {
            double x = this.lon2LambdaRad(lon);
            return new Point2D.Double((double)this.outCenterX_ + x * this.rS_, this.outCenterY_);
        }
        double halfLambdaRad = 0.5 * this.lon2LambdaRad(lon);
        double phiRad = Aitoff.toRadians(lat);
        if (halfLambdaRad == 0.0) {
            double y = phiRad;
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - y * this.rS_);
        }
        double cosPhi = Math.cos(phiRad);
        double cosAlpha = cosPhi * Math.cos(halfLambdaRad);
        double alphaRad = Math.acos(cosAlpha);
        if (Math.abs(alphaRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinAlpha = Math.sin(alphaRad);
        double cosBeta = Math.sin(phiRad) / sinAlpha;
        double sinBeta = cosPhi * Math.sin(halfLambdaRad) / sinAlpha;
        double x = 2.0 * alphaRad * sinBeta;
        double y = alphaRad * cosBeta;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double alphaRad = Math.hypot(0.5 * x, y) * this.oneOverRS_;
        double sinPhi = y * this.oneOverRS_ * Math.sin(alphaRad) / alphaRad;
        double phiRad = Math.asin(sinPhi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiRad));
        if (lambdaRad > Math.PI) {
            return null;
        }
        if (x < 0.0) {
            lambdaRad = 0.0 - lambdaRad;
        }
        double phi = Aitoff.toDegrees(phiRad);
        double lambda = Aitoff.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                double alphaRad = Math.hypot(0.5 * x, y) * this.oneOverRS_;
                if (alphaRad > 1.0E-5) {
                    double sinPhi = yOverRS * Math.sin(alphaRad) / alphaRad;
                    phiRad = Math.asin(sinPhi);
                    if (phiRad > 1.5707963267948966) continue block0;
                    double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiRad));
                    if (lambdaRad > Math.PI) {
                        continue block0;
                    }
                } else {
                    phiRad = 0.0;
                    lambdaRad = 0.0;
                }
                this.setQSymmetricPoints(ix, iy, Aitoff.toDegrees(lambdaRad), Aitoff.toDegrees(phiRad));
            }
        }
    }
}

