/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.img.ImageUtilities;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjParameterListener;
import gov.nasa.giss.map.proj.gui.ProjBooleanField;
import gov.nasa.giss.map.proj.gui.ProjDoubleField;
import gov.nasa.giss.map.proj.gui.ProjField;
import gov.nasa.giss.map.proj.gui.ProjListField;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjection
implements ProjParameterListener {
    public static final int CYLINDRIC = 2;
    public static final int PSEUDOCYLINDRIC = 4;
    public static final int CONIC = 8;
    public static final int POLYCONIC = 16;
    public static final int AZIMUTHAL = 32;
    public static final int PSEUDOAZIMUTHAL = 64;
    public static final int ORTHOAPSIDAL = 128;
    public static final int PSEUDOCONIC = 256;
    public static final int OBLIQUE = 131072;
    public static final int FUSION = 262144;
    public static final int INTERRUPTED = 524288;
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double PI2 = Math.PI * Math.PI;
    public static final double RAD_PER_DEG = Math.PI / 180;
    public static final double DEG_PER_RAD = 57.29577951308232;
    public static final double SQRT2 = 1.4142135623730951;
    private static final double DEFAULT_LAMBDA_C = 0.0;
    private static final double DEFAULT_PHI_C = 0.0;
    public static final double MIN_WIDTH = 0.002;
    public static final double MIN_HEIGHT = 0.002;
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    private static final Color DEFAULT_FOREGROUND = Color.BLACK;
    private static final BasicStroke DEFAULT_BORDER_STROKE = new BasicStroke(1.75f);
    private static final BasicStroke DEFAULT_PATH_STROKE = new BasicStroke(1.0f, 1, 1);
    private static final Color DEFAULT_GRID_COLOR = Color.GRAY;
    private static final BasicStroke DEFAULT_GRID_STROKE = new BasicStroke(1.0f);
    private BasicStroke borderStroke_ = DEFAULT_BORDER_STROKE;
    private static final int UNDEFINED = -999;
    private static final double UNKNOWN = 9999.0;
    protected static final double SMALL_VALUE = 1.0E-5;
    protected static final int ITER_MAX = 25;
    private static final PrintfFormat GRID_FORMATTER = new PrintfFormat("%.8G");
    private int[] srcPixels_;
    protected int srcWidth_ = 1;
    private int srcHeight_ = 1;
    private double srcCenterX_;
    private double srcCenterY_;
    private double srcCenterLon_;
    private double srcCenterLat_;
    private double srcWidthDeg_;
    private double srcHeightDeg_;
    private double srcPixelPerDegLon_;
    private double srcPixelPerDegLat_;
    protected int outWidth_ = 2;
    protected int outHeight_ = 2;
    protected int outCenterX_ = 1;
    protected int outCenterY_ = 1;
    private int marginL_ = 0;
    private int marginR_ = this.outWidth_;
    private int marginT_ = 0;
    private int marginB_ = this.outHeight_;
    private boolean needsInverseRefresh_ = true;
    protected int[] invArray_;
    protected double[] invArrayLon_;
    protected double[] invArrayLat_;
    protected double lambdaC_;
    protected double phiC_;
    private double rFactor_ = 1.0;
    private double zoom_ = 1.0;
    protected double rS_ = 1.0;
    protected double oneOverRS_ = 1.0;
    protected int xMax_;
    protected int yMax_;
    private double xMaxOverR_ = 1.0;
    private double yMaxOverR_ = 1.0;
    protected double xmRS_;
    protected double ymRS_;
    private String name_;
    private int properties_;
    private ArrayList<ExtraParameter> extraParams_;
    private Color background_;
    private Color foreground_ = DEFAULT_FOREGROUND;
    private double lonGridSpacing_ = 30.0;
    private double latGridSpacing_ = 30.0;
    private Color gridColor_ = DEFAULT_GRID_COLOR;
    private BasicStroke gridStroke_ = DEFAULT_GRID_STROKE;
    protected boolean gridLabeled_ = false;
    protected int gridLabelAlternation_ = 2;
    protected Font gridFont_;
    private PointLL[] pathLLPoints_;
    private Color pathColor_ = Color.RED;
    private BasicStroke pathStroke_ = DEFAULT_PATH_STROKE;
    private boolean initialized_;

    public AbstractProjection() {
        throw new IllegalArgumentException("Use a constructor which has arguments");
    }

    public AbstractProjection(String name, int properties, int w, int h, int xm, int ym, double xMaxOverR, double yMaxOverR) {
        this.name_ = name;
        this.properties_ = properties;
        this.setCenter(0.0, 0.0);
        this.setBackground(DEFAULT_BACKGROUND);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setSizeFactors(xMaxOverR, yMaxOverR);
        this.setSize(w, h, xm, ym);
        this.initialized_ = true;
    }

    public String getName() {
        return this.name_;
    }

    public int getProperties() {
        return this.properties_;
    }

    public boolean isAzimuthal() {
        return (this.properties_ & 0x20) != 0;
    }

    public boolean isRecenterableLon() {
        return true;
    }

    public boolean isRecenterableLat() {
        return this.isOblique();
    }

    public boolean isOblique() {
        return (this.properties_ & 0x20000) != 0;
    }

    public boolean isConic() {
        return (this.properties_ & 8) != 0;
    }

    public boolean isPseudocylindric() {
        return (this.properties_ & 4) != 0;
    }

    public boolean isInterrupted() {
        return (this.properties_ & 0x80000) != 0;
    }

    protected void setSizeFactors(double xMaxOverR, double yMaxOverR) {
        this.xMaxOverR_ = xMaxOverR;
        this.yMaxOverR_ = yMaxOverR;
    }

    public Dimension getSize() {
        return new Dimension(this.outWidth_, this.outHeight_);
    }

    public void setSize(int w, int h, int xm, int ym) {
        if (w != this.outWidth_ || h != this.outHeight_) {
            this.invArray_ = null;
        }
        this.outWidth_ = w;
        this.outHeight_ = h;
        this.marginL_ = xm;
        this.marginR_ = w - xm;
        this.marginT_ = ym;
        this.marginB_ = h - ym;
        this.outCenterX_ = (int)(0.5 * (double)w);
        this.outCenterY_ = (int)(0.5 * (double)h);
        if (this.initialized_) {
            this.autoscale();
        } else {
            this.calculateScaling();
        }
    }

    public Dimension getMarginSize() {
        return new Dimension(this.marginL_, this.marginT_);
    }

    protected final void autoscale() {
        this.prepareScaling();
        this.calculateScaling();
        this.finishScaling();
        this.setNeedsInverseArrayUpdate();
    }

    protected void prepareScaling() {
    }

    protected void finishScaling() {
    }

    protected final void calculateScaling() {
        int uw = this.outWidth_ - 2 * this.marginL_;
        int uh = this.outHeight_ - 2 * this.marginT_;
        this.rFactor_ = 0.5 * Math.min((double)uw / this.xMaxOverR_, (double)uh / this.yMaxOverR_);
        this.rS_ = this.rFactor_ * this.zoom_;
        this.oneOverRS_ = 1.0 / this.rS_;
        this.ymRS_ = this.yMaxOverR_ * this.rS_;
        this.xmRS_ = this.xMaxOverR_ * this.rS_;
        if (this.isAzimuthal() || this.isConic()) {
            this.xMax_ = (int)(0.5 * (double)uw + 0.5);
            this.yMax_ = (int)(0.5 * (double)uh + 0.5);
        } else {
            this.xMax_ = (int)(Math.min(0.5 * (double)uw, this.xmRS_) + 0.5);
            this.yMax_ = (int)(Math.min(0.5 * (double)uh, this.ymRS_) + 0.5);
        }
        this.setNeedsInverseArrayUpdate();
    }

    protected boolean isWithinMargins(Point2D.Double pt) {
        if (pt == null) {
            return false;
        }
        return this.isWithinMargins(pt.x, pt.y);
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        Point2D.Double result = this.transformLL2XYIgnoreMargins(lon, lat);
        if (result == null) {
            return result;
        }
        if (this.isWithinMargins(result)) {
            return result;
        }
        return null;
    }

    public Point2D.Double transformLL2XY(PointLL ll) {
        Point2D.Double result = this.transformLL2XYIgnoreMargins(ll);
        if (result == null) {
            return result;
        }
        if (this.isWithinMargins(result)) {
            return result;
        }
        return null;
    }

    public Point transformLL2XYInt(double lon, double lat) {
        Point2D.Double p2d = this.transformLL2XY(lon, lat);
        if (p2d == null) {
            return null;
        }
        return new Point((int)p2d.x, (int)p2d.y);
    }

    public abstract Point2D.Double transformLL2XYIgnoreMargins(double var1, double var3);

    public Point2D.Double transformLL2XYIgnoreMargins(PointLL ll) {
        return this.transformLL2XY(ll.getLon(), ll.getLat());
    }

    protected boolean isWithinMargins(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return false;
        }
        return !(x < (double)this.marginL_ - 0.6 || y < (double)this.marginT_ - 0.6 || x > (double)this.marginR_ + 0.6) && !(y > (double)this.marginB_ + 0.6);
    }

    public abstract PointLL transformXY2LL(double var1, double var3);

    public PointLL transformXY2LL(int x, int y) {
        if (this.needsInverseRefresh_) {
            this.refreshInverseArray();
        }
        if (!this.isWithinMargins(x, y)) {
            return null;
        }
        int offset = y * this.outWidth_ + x;
        if (offset < 0 || offset >= this.invArray_.length || Double.isNaN(this.invArrayLon_[offset]) || Double.isNaN(this.invArrayLat_[offset])) {
            return null;
        }
        return new PointLL(this.invArrayLon_[offset], this.invArrayLat_[offset]);
    }

    public PointLL transformXY2LL(Point xy) {
        return this.transformXY2LL(xy.x, xy.y);
    }

    private double transformLLAngle2XYAngle(double lon, double lat, double angleRad) {
        if (Math.abs(lat) >= 90.0) {
            return Double.NaN;
        }
        Point2D.Double dot1 = this.transformLL2XY(lon, lat);
        if (dot1 == null) {
            return Double.NaN;
        }
        Point2D.Double dot2 = this.transformLL2XY(lon, lat + 0.001);
        double dx2 = dot2.x - dot1.x;
        double dy2 = dot2.y - dot1.y;
        double northRad = Math.atan2(dx2, -dy2);
        Point2D.Double dot3 = this.transformLL2XY(lon + 0.001 * Math.sin(angleRad) / Math.cos(AbstractProjection.toRadians(lat)), lat + 0.001 * Math.cos(angleRad));
        if (dot2 == null) {
            return Double.NaN;
        }
        double dx3 = dot3.x - dot1.x;
        double dy3 = dot3.y - dot1.y;
        double xyRad = Math.atan2(dx3, -dy3);
        return xyRad;
    }

    public double transformLLAngle2XYAngle(PointLL ll, double angle) {
        return this.transformLLAngle2XYAngle(ll.getLon(), ll.getLat(), angle);
    }

    protected double lon2Lambda(double lon) {
        double lambda;
        for (lambda = lon - this.lambdaC_; lambda > 180.0; lambda -= 360.0) {
        }
        while (lambda < -180.0) {
            lambda += 360.0;
        }
        return lambda;
    }

    protected double lon2LambdaRad(double lon) {
        return this.lon2Lambda(lon) * (Math.PI / 180);
    }

    public PointLL getCenter() {
        return new PointLL(this.lambdaC_, this.phiC_);
    }

    public void setCenter(double lon) {
        this.setCenter(lon, 0.0);
    }

    public void setCenter(PointLL pt) {
        this.setCenter(pt.getLon(), pt.getLat());
    }

    public void setCenter(double lon, double lat) {
        if (lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Invalid latitude value.");
        }
        this.lambdaC_ = AbstractProjection.normalizeLon180(lon);
        this.phiC_ = lat;
        this.setNeedsInverseArrayUpdate();
    }

    public double getZoom() {
        return this.zoom_;
    }

    public void setZoom(double zoom) {
        if (zoom <= 0.0) {
            throw new IllegalArgumentException("Illegal zoom factor");
        }
        if (zoom == this.zoom_) {
            return;
        }
        this.zoom_ = zoom;
        this.autoscale();
    }

    public Color getBackground() {
        return this.background_;
    }

    public void setBackground(Color color) {
        this.background_ = color;
    }

    public Color getForeground() {
        return this.foreground_;
    }

    public void setForeground(Color color) {
        this.foreground_ = color;
    }

    public BasicStroke getBorderStroke() {
        return this.borderStroke_;
    }

    public void setBorderStroke(BasicStroke stroke) {
        this.borderStroke_ = stroke;
    }

    public Color getGridColor() {
        return this.gridColor_;
    }

    public void setGridColor(Color color) {
        this.gridColor_ = color;
    }

    public BasicStroke getGridStroke() {
        return this.gridStroke_;
    }

    public void setGridStroke(BasicStroke stroke) {
        this.gridStroke_ = stroke;
    }

    public void setGridSpacing(double spacing) {
        this.setGridSpacing(spacing, spacing);
    }

    public void setGridSpacing(double lonSpacing, double latSpacing) {
        this.setLonGridSpacing(lonSpacing);
        this.setLatGridSpacing(latSpacing);
    }

    public double getLonGridSpacing() {
        return this.lonGridSpacing_;
    }

    public void setLonGridSpacing(double spacing) {
        this.lonGridSpacing_ = Math.max(spacing, 0.0);
    }

    public double getLatGridSpacing() {
        return this.latGridSpacing_;
    }

    public void setLatGridSpacing(double spacing) {
        this.latGridSpacing_ = Math.max(spacing, 0.0);
    }

    public void setGridFont(Font f) {
        this.gridFont_ = f;
    }

    public boolean canLabelGrid() {
        return false;
    }

    public boolean isGridLabeled() {
        return this.gridLabeled_;
    }

    public void setGridLabeled(boolean b) {
        this.gridLabeled_ = b;
    }

    public PointLL[] getPathPoints() {
        return this.pathLLPoints_;
    }

    public void setPathPoints(PointLL[] points) {
        this.pathLLPoints_ = points;
    }

    public Color getPathColor() {
        return this.pathColor_;
    }

    public void setPathColor(Color color) {
        this.pathColor_ = color;
    }

    public BasicStroke getPathStroke() {
        return this.pathStroke_;
    }

    public void setPathStroke(BasicStroke stroke) {
        this.pathStroke_ = stroke;
    }

    public void setSource(BufferedImage source) {
        this.setSource(source, 90.0, 180.0, -90.0, -180.0);
    }

    public void setSource(BufferedImage source, double top, double right, double bottom, double left) {
        int hpxl;
        int wpxl;
        if (top > 90.0) {
            throw new IllegalArgumentException("Upper latitude bound > 90.");
        }
        if (bottom < -90.0) {
            throw new IllegalArgumentException("Bottom latitude bound < -90.");
        }
        if (top < bottom) {
            throw new IllegalArgumentException("Upper latitude bound must be > lower.");
        }
        left = AbstractProjection.normalizeLon180(left);
        while (right <= left) {
            right += 360.0;
        }
        if (right - left > 360.0) {
            throw new IllegalArgumentException("Difference between left and right bounds > 360.");
        }
        double wdeg = right - left;
        double hdeg = top - bottom;
        if (wdeg != this.srcWidthDeg_) {
            this.srcWidthDeg_ = wdeg;
            this.setNeedsInverseArrayUpdate();
        }
        if (hdeg != this.srcHeightDeg_) {
            this.srcHeightDeg_ = hdeg;
            this.setNeedsInverseArrayUpdate();
        }
        double clon = 0.5 * (right + left);
        double clat = 0.5 * (top + bottom);
        if (clon != this.srcCenterLon_) {
            this.srcCenterLon_ = clon;
            this.setNeedsInverseArrayUpdate();
        }
        if (clat != this.srcCenterLat_) {
            this.srcCenterLat_ = clat;
            this.setNeedsInverseArrayUpdate();
        }
        if (source == null) {
            this.srcPixels_ = null;
            wpxl = 2;
            hpxl = 2;
        } else {
            wpxl = source.getWidth(null);
            hpxl = source.getHeight(null);
            this.srcPixels_ = ImageUtilities.getARGBPixels(source);
        }
        if (wpxl != this.srcWidth_) {
            this.srcWidth_ = wpxl;
            this.setNeedsInverseArrayUpdate();
        }
        if (hpxl != this.srcHeight_) {
            this.srcHeight_ = hpxl;
            this.setNeedsInverseArrayUpdate();
        }
        this.srcCenterX_ = 0.5 * (double)wpxl;
        this.srcCenterY_ = 0.5 * (double)hpxl;
        this.srcPixelPerDegLon_ = (double)wpxl / wdeg;
        this.srcPixelPerDegLat_ = (double)hpxl / hdeg;
    }

    public int getParameterCount() {
        if (this.extraParams_ == null) {
            return 0;
        }
        return this.extraParams_.size();
    }

    public ExtraParameter getParameter(int pid) {
        if (this.extraParams_ == null || pid < 0 || pid >= this.extraParams_.size()) {
            throw new IllegalArgumentException("Bad parameter number.");
        }
        return this.extraParams_.get(pid);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
    }

    protected void addParameter(ExtraParameter param) {
        if (this.extraParams_ == null) {
            this.extraParams_ = new ArrayList(5);
        }
        this.extraParams_.add(param);
        param.setParent(this);
        param.addParameterListener(this);
        try {
            this.parameterChanged(new ProjParameterEvent(param));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProjField getParameterField(int pid) {
        ExtraParameter xp = this.extraParams_.get(pid);
        if (xp == null) {
            return null;
        }
        if (xp instanceof DoubleParameter) {
            return new ProjDoubleField((DoubleParameter)xp);
        }
        if (xp instanceof BooleanParameter) {
            return new ProjBooleanField((BooleanParameter)xp);
        }
        if (xp instanceof ListParameter) {
            return new ProjListField((ListParameter)xp);
        }
        return null;
    }

    public void paintCompleteMap(Graphics2D g2d) {
        if (this.needsInverseRefresh_) {
            this.refreshInverseArray();
        }
        this.paintMap(g2d);
        this.drawPath(g2d, this.pathLLPoints_, this.pathStroke_, this.pathColor_);
        this.drawGrid(g2d);
        this.drawBorder(g2d);
    }

    public synchronized void paintMap(Graphics2D g2d) {
        if (this.srcPixels_ == null) {
            g2d.setColor(this.background_);
            g2d.fillRect(0, 0, this.outWidth_, this.outHeight_);
            return;
        }
        if (this.needsInverseRefresh_) {
            this.refreshInverseArray();
        }
        int backgroundRGB = this.background_.getRGB();
        int[] dstPixels = new int[this.outWidth_ * this.outHeight_];
        int offset = 0;
        int rowOffset = 0;
        for (int row = 0; row < this.outHeight_; ++row) {
            rowOffset = row * this.outWidth_;
            for (int col = 0; col < this.outWidth_; ++col) {
                offset = rowOffset + col;
                if (this.invArray_[offset] >= 0 && this.invArray_[offset] < this.srcPixels_.length) {
                    if (this.srcPixels_[this.invArray_[offset]] == 0) {
                        dstPixels[offset] = backgroundRGB;
                        continue;
                    }
                    dstPixels[offset] = this.srcPixels_[this.invArray_[offset]];
                    continue;
                }
                dstPixels[offset] = backgroundRGB;
            }
        }
        try {
            g2d.drawImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.outWidth_, this.outHeight_, dstPixels, 0, this.outWidth_)), 0, 0, null);
        }
        catch (Exception exc) {
            System.out.println("ERROR: paintMap MemoryImageSource error");
            exc.printStackTrace();
        }
    }

    public void drawMapDevo(Graphics2D g2d) {
        if (this.srcPixels_ == null) {
            g2d.setColor(this.background_);
            g2d.fillRect(0, 0, this.outWidth_, this.outHeight_);
            return;
        }
        if (this.needsInverseRefresh_) {
            this.refreshInverseArray();
        }
        int backgroundRGB = this.background_.getRGB();
        int[] dstPixels = new int[this.outWidth_ * this.outHeight_];
        int offset = 0;
        int rowOffset = 0;
        for (int row = 0; row < this.outHeight_; ++row) {
            rowOffset = row * this.outWidth_;
            for (int col = 0; col < this.outWidth_; ++col) {
                offset = rowOffset + col;
                dstPixels[offset] = this.invArray_[offset] >= 0 && this.invArray_[offset] < this.srcPixels_.length ? this.srcPixels_[this.invArray_[offset]] : backgroundRGB;
            }
        }
        Vector<ColorArea> areas = new Vector<ColorArea>(2000);
        for (int row = 0; row < this.outHeight_; ++row) {
            rowOffset = row * this.outWidth_;
            int first = 0;
            for (int col = 1; col < this.outWidth_ - 1; ++col) {
                offset = rowOffset + col;
                if (dstPixels[offset] == dstPixels[rowOffset + first]) continue;
                Rectangle2D.Float area = new Rectangle2D.Float(first, row, col - first, 1.0f);
                areas.add(new ColorArea(dstPixels[rowOffset + first], new Area(area)));
                first = col;
            }
            Rectangle2D.Float area = new Rectangle2D.Float(first, row, this.outWidth_ - 1 - first, 1.0f);
            areas.add(new ColorArea(dstPixels[rowOffset + first], new Area(area)));
            if (areas.size() <= 1975) continue;
            this.drawPrintAreasDevo(g2d, areas);
            areas.clear();
        }
        this.drawPrintAreasDevo(g2d, areas);
    }

    private void drawPrintAreasDevo(Graphics2D g2d, Vector<ColorArea> areas) {
        while (areas.size() > 0) {
            ColorArea carea = areas.remove(areas.size() - 1);
            int colorval = carea.colorval_;
            Area area = carea.area_;
            for (int i = areas.size() - 1; i >= 0; --i) {
                carea = areas.elementAt(i);
                if (carea.colorval_ != colorval) continue;
                area.add(carea.area_);
                areas.remove(i);
            }
            g2d.setColor(new Color(colorval));
            g2d.fill(area);
        }
    }

    public void drawGrid(Graphics2D g2d) {
        this.drawGrid(g2d, this.gridStroke_, this.gridColor_);
    }

    public void drawGrid(Graphics2D g2d, BasicStroke stroke, Color color) {
        if (color == null || stroke == null) {
            return;
        }
        g2d.setColor(color);
        g2d.setStroke(stroke);
        g2d.setFont(this.gridFont_);
        this.drawParallels(g2d);
        this.drawMeridians(g2d);
    }

    protected void drawParallels(Graphics2D g2d) {
        if (this.latGridSpacing_ <= 0.0) {
            return;
        }
        String label = null;
        int steps = (int)(90.0 / this.latGridSpacing_);
        for (int j = 0; j < steps; ++j) {
            double lat = this.latGridSpacing_ * (double)j;
            boolean showLabel = this.gridLabeled_ && this.gridLabelAlternation_ > 0 && j % this.gridLabelAlternation_ == 0;
            FontMetrics fm = g2d.getFontMetrics();
            label = showLabel ? GRID_FORMATTER.sprintf(lat) + "N" : null;
            this.drawParallel(g2d, lat, label);
            if (!(lat > 0.0)) continue;
            label = showLabel ? GRID_FORMATTER.sprintf(lat) + "S" : null;
            this.drawParallel(g2d, -lat, label);
        }
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.lambdaC_ - 180.0 + 1.0E-5;
        double rlon = this.lambdaC_ + 180.0 - 1.0E-5;
        if ((this.properties_ & 4) != 0 && (this.properties_ & 4) != 0) {
            Point2D.Double dot1 = this.transformLL2XY(llon, lat);
            Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
            if (dot1 == null || dot2 == null) {
                return;
            }
            Path2D.Double path = new Path2D.Double();
            path.moveTo((float)dot1.x, (float)dot1.y);
            path.lineTo((float)dot2.x, (float)dot2.y);
            g2d.draw(path);
            return;
        }
        double istep = 0.5;
        int isteps = 720;
        PointLL[] latPoints = new PointLL[721];
        for (int ilon = 0; ilon <= 720; ++ilon) {
            double lon = llon + 0.5 * (double)ilon;
            if (latPoints[ilon] == null) {
                latPoints[ilon] = new PointLL(lon, lat);
                continue;
            }
            latPoints[ilon].setLat(lat);
        }
        this.drawBezier(g2d, this.translatePath(latPoints));
    }

    protected void drawMeridians(Graphics2D g2d) {
        if (this.lonGridSpacing_ <= 0.0) {
            return;
        }
        String label = null;
        int steps = (int)(180.0 / this.lonGridSpacing_);
        for (int i = 0; i <= steps; ++i) {
            double lon = this.lonGridSpacing_ * (double)i;
            boolean showLabel = this.gridLabeled_ && this.gridLabelAlternation_ > 0 && i % this.gridLabelAlternation_ == 0;
            label = showLabel ? GRID_FORMATTER.sprintf(lon) + "E" : null;
            this.drawMeridian(g2d, lon, label);
            if (!(lon > 0.0) || !(lon < 180.0)) continue;
            label = showLabel ? GRID_FORMATTER.sprintf(lon) + "W" : null;
            this.drawMeridian(g2d, -lon, label);
        }
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if ((this.properties_ & 4) != 0 || (this.properties_ & 0x10) != 0 || (this.properties_ & 0x80) != 0) {
            double diff;
            for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
            }
            while (diff < 0.0) {
                diff += 360.0;
            }
            if (Math.abs(diff - 180.0) < 1.0E-5) {
                return;
            }
        }
        double jstep = 0.25;
        int jsteps = 720;
        PointLL[] llpts = new PointLL[721];
        for (int jj = 0; jj <= 720; ++jj) {
            double lat = -90.0 + 0.25 * (double)jj;
            if (jj == 0) {
                lat = -89.995;
            } else if (jj == 720) {
                lat = 89.995;
            }
            llpts[jj] = new PointLL(lon, lat);
        }
        this.drawBezier(g2d, this.translatePath(llpts));
    }

    protected void drawBezier(Graphics2D g2d, Point2D.Double[] points) {
        Vector<Point2D.Double> segment = new Vector<Point2D.Double>(points.length);
        Point2D.Double prevPt = null;
        for (Point2D.Double point : points) {
            if (point == null) {
                if (prevPt != null) {
                    this.drawBezier(g2d, segment);
                    segment.removeAllElements();
                }
                prevPt = null;
                continue;
            }
            segment.add(point);
            prevPt = new Point2D.Double(point.x, point.y);
        }
        this.drawBezier(g2d, segment);
    }

    protected void drawBezier(Graphics2D g2d, Vector<Point2D.Double> points) {
        if (points.size() < 2) {
            return;
        }
        Point2D.Double first = points.firstElement();
        Point2D.Double last = points.lastElement();
        boolean closed = first.x == last.x && first.y == last.y;
        Bezier b = new Bezier(closed, points);
        if (b != null) {
            b.paint(g2d);
        }
    }

    public void drawDot(Graphics2D g2d, PointLL llPoint, BasicStroke stroke, Color fillColor, Color edgeColor, double radius) {
        if (fillColor == null && edgeColor == null) {
            return;
        }
        Point2D.Double xy = this.transformLL2XY(llPoint.getLon(), llPoint.getLat());
        if (xy == null) {
            return;
        }
        Ellipse2D.Double dot = new Ellipse2D.Double(xy.getX() - radius, xy.getY() - radius, radius * 2.0, radius * 2.0);
        if (fillColor != null) {
            g2d.setColor(fillColor);
            g2d.fill(dot);
        }
        if (edgeColor != null && stroke != null) {
            g2d.setColor(edgeColor);
            g2d.setStroke(stroke);
            g2d.draw(dot);
        }
    }

    public void drawPath(Graphics2D g2d) {
        this.drawPath(g2d, this.pathLLPoints_, this.pathStroke_, this.pathColor_);
    }

    public void drawPath(Graphics2D g2d, PointLL[] llPoints) {
        this.drawPath(g2d, llPoints, this.pathStroke_, this.pathColor_);
    }

    public void drawPath(Graphics2D g2d, PointLL[] llPoints, BasicStroke stroke, Color color) {
        this.drawPath(g2d, llPoints, stroke, color, null, null);
    }

    public void drawPath(Graphics2D g2d, PointLL[] llPoints, BasicStroke stroke, Color color, String ltext, Font lfont) {
        float py;
        float px;
        if (llPoints == null || llPoints.length == 0 || stroke == null || color == null || color.getAlpha() == 0) {
            return;
        }
        g2d.setColor(color);
        g2d.setStroke(stroke);
        Point2D.Double[] xyPoints = this.translatePath(llPoints);
        Polygon lpoly = null;
        if (ltext != null && lfont != null && ltext.length() > 0 && xyPoints.length > 50) {
            g2d.setFont(lfont);
            FontMetrics fm = g2d.getFontMetrics();
            int twidth = fm.stringWidth(ltext);
            for (int i = xyPoints.length / 4; i < xyPoints.length - 10; i += 5) {
                boolean goodpt = true;
                for (int j = -5; j < 6; ++j) {
                    if (xyPoints[i + j] != null) continue;
                    goodpt = false;
                    break;
                }
                if (!goodpt) continue;
                Point2D.Double p0 = xyPoints[i];
                Point2D.Double pa = xyPoints[i - 3];
                Point2D.Double pb = xyPoints[i + 3];
                double dy = pb.y - pa.y;
                double dx = pb.x - pa.x;
                double rad = Math.atan2(dy, dx);
                if (rad > 1.5707963267948966) {
                    rad -= Math.PI;
                }
                if (rad < -1.5707963267948966) {
                    rad += Math.PI;
                }
                px = (float)p0.x;
                py = (float)p0.y;
                float hw = (float)(0.5 * (double)twidth);
                float hh = (float)(0.5 * (double)fm.getAscent());
                Point[] pc = this.findLabelCorners(px, py, twidth, fm.getAscent(), (float)rad);
                if (this.transformXY2LL(pc[0]) == null || this.transformXY2LL(pc[1]) == null || this.transformXY2LL(pc[2]) == null || this.transformXY2LL(pc[3]) == null) continue;
                g2d.translate(px, py);
                g2d.rotate(rad);
                GraphicUtilities.drawString(g2d, ltext, -hw, hh);
                g2d.rotate(-rad);
                g2d.translate(-px, -py);
                lpoly = new Polygon(new int[]{pc[0].x, pc[1].x, pc[2].x, pc[3].x}, new int[]{pc[0].y, pc[1].y, pc[2].y, pc[3].y}, 4);
                break;
            }
        }
        Path2D.Double path = new Path2D.Double();
        for (Point2D.Double pt : xyPoints) {
            if (pt == null) {
                if (path.getCurrentPoint() != null) {
                    g2d.draw(path);
                }
                path.reset();
                continue;
            }
            px = (float)pt.x;
            py = (float)pt.y;
            if (lpoly != null && lpoly.contains(px, py)) {
                if (path.getCurrentPoint() != null) {
                    g2d.draw(path);
                }
                path.reset();
                continue;
            }
            if (path.getCurrentPoint() != null) {
                path.lineTo(px, py);
                continue;
            }
            path.moveTo(px, py);
        }
        if (path.getCurrentPoint() != null) {
            g2d.draw(path);
        }
    }

    private Point[] findLabelCorners(float px, float py, float w, float h, float angle) {
        float hw = (float)(0.6 * (double)w);
        float hh = (float)(0.6 * (double)h);
        float cosA = (float)Math.cos(angle);
        float sinA = (float)Math.sin(angle);
        int px1 = (int)(px + hw * cosA - hh * sinA);
        int px2 = (int)(px + hw * cosA + hh * sinA);
        int px3 = (int)(px - hw * cosA + hh * sinA);
        int px4 = (int)(px - hw * cosA - hh * sinA);
        int py1 = (int)(py + hw * sinA + hh * cosA);
        int py2 = (int)(py + hw * sinA - hh * cosA);
        int py3 = (int)(py - hw * sinA - hh * cosA);
        int py4 = (int)(py - hw * sinA + hh * cosA);
        return new Point[]{new Point(px1, py1), new Point(px2, py2), new Point(px3, py3), new Point(px4, py4)};
    }

    public void drawBorder(Graphics2D g2d) {
        this.drawBorder(g2d, this.getBorderStroke(), this.getForeground());
    }

    public void drawBorder(Graphics2D g2d, BasicStroke stroke, Color color) {
        if (stroke == null || color == null) {
            return;
        }
        g2d.setStroke(stroke);
        g2d.setColor(color);
        this.drawBorderLines(g2d);
    }

    protected abstract void drawBorderLines(Graphics2D var1);

    protected int getSrcPixelX(double lon) {
        double dlon;
        if (this.srcWidth_ < 1) {
            return -1;
        }
        for (dlon = lon - this.srcCenterLon_; dlon < -180.0; dlon += 360.0) {
        }
        while (dlon > 180.0) {
            dlon -= 360.0;
        }
        int x = (int)(this.srcCenterX_ + this.srcPixelPerDegLon_ * dlon - 0.5);
        if (x < 0 || x >= this.srcWidth_) {
            return -1;
        }
        return x;
    }

    protected int getSrcPixelY(double lat) {
        if (this.srcHeight_ < 1) {
            return -1;
        }
        int y = (int)(this.srcCenterY_ - this.srcPixelPerDegLat_ * (lat - this.srcCenterLat_) - 0.5);
        if (y < 0 || y >= this.srcHeight_) {
            return -1;
        }
        return y;
    }

    protected void setNeedsInverseArrayUpdate() {
        this.needsInverseRefresh_ = true;
    }

    private void refreshInverseArray() {
        if (this.invArray_ == null) {
            this.invArray_ = new int[this.outWidth_ * this.outHeight_];
            this.invArrayLon_ = new double[this.outWidth_ * this.outHeight_];
            this.invArrayLat_ = new double[this.outWidth_ * this.outHeight_];
        }
        for (int j = 0; j < this.outHeight_; ++j) {
            for (int i = 0; i < this.outWidth_; ++i) {
                int offset = j * this.outWidth_ + i;
                this.invArray_[offset] = -999;
                this.invArrayLon_[offset] = Double.NaN;
                this.invArrayLat_[offset] = Double.NaN;
            }
        }
        this.calculateInverseArray();
        this.needsInverseRefresh_ = false;
    }

    protected abstract void calculateInverseArray();

    protected static double normalizeLon180(double lon) {
        while (lon < -180.0) {
            lon += 360.0;
        }
        while (lon >= 180.0) {
            lon -= 360.0;
        }
        return lon;
    }

    protected static double normalizeLon360(double lon) {
        while (lon < 0.0) {
            lon += 360.0;
        }
        while (lon >= 360.0) {
            lon -= 360.0;
        }
        return lon;
    }

    protected Point2D.Double[] translatePath(PointLL[] llPoints) {
        double copLon = this.lambdaC_;
        Point2D.Double prevDot = null;
        PointLL prevLL = null;
        Point2D.Double midDot = null;
        PointLL midLL = null;
        Vector<Point2D.Double> v = new Vector<Point2D.Double>(llPoints.length + 50);
        for (PointLL ll : llPoints) {
            Point2D.Double edgeDot;
            Object[] edge;
            double lat;
            if (ll == null) {
                if (v.size() > 0 && v.lastElement() != null) {
                    v.add(null);
                }
                prevDot = null;
                prevLL = null;
                continue;
            }
            double lon = ll.getLon();
            Point2D.Double dot = this.transformLL2XY(lon, lat = ll.getLat());
            if (dot != null && !this.isWithinMargins(dot.x, dot.y)) {
                dot = null;
            }
            if (prevLL == null) {
                if (dot != null) {
                    v.add(dot);
                    prevDot = dot;
                    prevLL = ll.copy();
                    continue;
                }
                prevDot = null;
                prevLL = ll.copy();
                continue;
            }
            if (dot == null && prevDot == null) {
                if (v.size() > 0 && v.lastElement() != null) {
                    v.add(null);
                }
                prevDot = null;
                prevLL = ll.copy();
                continue;
            }
            if (dot != null && prevDot != null) {
                Object[] mid = this.findMidpoint(ll, prevLL);
                if (mid != null) {
                    midLL = (PointLL)mid[0];
                    midDot = (Point2D.Double)mid[1];
                } else {
                    midLL = null;
                    midDot = null;
                }
                if (midDot == null) {
                    v.add(null);
                } else {
                    double dx1 = midDot.x - prevDot.x;
                    double dx2 = dot.x - midDot.x;
                    double dx12 = dot.x - prevDot.x;
                    double dy1 = midDot.y - prevDot.y;
                    double dy2 = dot.y - midDot.y;
                    double dy12 = dot.y - prevDot.y;
                    double d1 = Math.hypot(dx1, dy1);
                    double d2 = Math.hypot(dx2, dy2);
                    double d12 = Math.hypot(dx12, dy12);
                    if (dx1 < 0.0 && dx2 > 0.0 || dx1 > 0.0 && dx2 < 0.0) {
                        v.add(null);
                    } else if (d12 > 1.0 && d1 / d12 < 0.25) {
                        v.add(midDot);
                        v.add(null);
                    } else if (d12 > 1.0 && d2 / d12 < 0.25) {
                        v.add(null);
                        v.add(midDot);
                    } else if (!(dx1 >= 0.0 && dx2 >= 0.0 || dx1 <= 0.0 && dx2 <= 0.0)) {
                        v.add(null);
                    }
                }
                v.add(dot);
                prevDot = dot;
                prevLL = ll.copy();
                continue;
            }
            if (dot == null && prevDot != null) {
                Point2D.Double edgeDot2;
                edge = this.findEdgePoint(0, prevLL, ll);
                if (edge != null && (edgeDot2 = (Point2D.Double)edge[1]) != null) {
                    v.add(edgeDot2);
                }
                v.add(null);
                prevDot = null;
                prevLL = ll.copy();
                continue;
            }
            edge = this.findEdgePoint(0, ll, prevLL);
            if (edge != null && (edgeDot = (Point2D.Double)edge[1]) != null) {
                v.add(edgeDot);
            }
            v.add(dot);
            prevDot = dot;
            prevLL = ll.copy();
        }
        Point2D.Double[] result = v.toArray(new Point2D.Double[0]);
        return result;
    }

    private Object[] findMidpoint(PointLL ll1, PointLL ll2) {
        double lon1 = ll1.getLon();
        double lon2 = ll2.getLon();
        PointLL ll = new PointLL();
        if (Math.abs(lon1 - lon2) < 180.0) {
            ll.setLon(0.5 * (lon1 + lon2));
        } else {
            ll.setLon(0.5 * (lon1 + lon2) + 180.0);
        }
        ll.setLat(0.5 * (ll1.getLat() + ll2.getLat()));
        return new Object[]{ll, this.transformLL2XY(ll)};
    }

    private Object[] findEdgePoint(int iternum, PointLL insideLL, PointLL outsideLL) {
        double lon1 = insideLL.getLon();
        double lon2 = outsideLL.getLon();
        Object[] o = this.findMidpoint(insideLL, outsideLL);
        PointLL ll = (PointLL)o[0];
        Point2D.Double dot = (Point2D.Double)o[1];
        if (dot == null) {
            if (iternum > 15) {
                return null;
            }
            return this.findEdgePoint(iternum + 1, insideLL, ll);
        }
        Point2D.Double insideDot = this.transformLL2XY(insideLL);
        if (Math.abs(dot.x - insideDot.x) < 2.0 && Math.abs(dot.y - insideDot.y) < 2.0) {
            return new Object[]{ll, dot};
        }
        return this.findEdgePoint(iternum + 1, ll, outsideLL);
    }

    protected static final double toDegrees(double radianValue) {
        return radianValue * 57.29577951308232;
    }

    protected static final double toRadians(double degreeValue) {
        return degreeValue * (Math.PI / 180);
    }

    private class ColorArea {
        public int colorval_;
        public Area area_;

        ColorArea(int colorval, Area area) {
            this.colorval_ = colorval;
            this.area_ = area;
        }
    }
}

