/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;

public class TOutlineOverlay
extends OutlineOverlay {
    public TOutlineOverlay(File f) throws IOException, FileNotFoundException {
        super(f);
    }

    public TOutlineOverlay(URL url) throws IOException, FileNotFoundException {
        super(url);
    }

    public TOutlineOverlay(byte[] bytes, String identifier) throws IOException {
        super(bytes, identifier);
    }

    protected void readStream(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        int capacity = 20000;
        ArrayList<PointLL> temporary = new ArrayList<PointLL>(capacity);
        BufferedReader bStream = new BufferedReader(isr);
        String aLine = "";
        while ((aLine = bStream.readLine()) != null) {
            int commaAt;
            if (temporary.size() >= capacity - 100) {
                temporary.ensureCapacity(capacity += 1000);
            }
            if ((commaAt = aLine.indexOf(",")) > -1) {
                try {
                    double lon = Double.parseDouble(aLine.substring(0, commaAt));
                    double lat = Double.parseDouble(aLine.substring(commaAt + 1));
                    temporary.add(new PointLL(lon, lat));
                }
                catch (Exception ignore) {
                    temporary.add(null);
                    System.err.println("WARNING: Bad outline point at line " + temporary.size());
                }
                continue;
            }
            temporary.add(null);
        }
        isr.close();
        this.points_ = temporary.toArray(new PointLL[0]);
    }

    public String getDescription() {
        return super.getDescription() + " outline";
    }
}

