/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.overlay.OverlayFactory;
import java.io.File;
import java.io.FilenameFilter;

public class OverlayFilenameFilter
implements FilenameFilter {
    public static final String[] EXTENSIONS = OverlayFactory.getValidExtensions();

    public boolean accept(File dir, String name) {
        if (OverlayFilenameFilter.isOverlayName(name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean isOverlayName(File f) {
        if (f == null) {
            throw new IllegalArgumentException("File is null.");
        }
        return OverlayFilenameFilter.isOverlayName(f.getName());
    }

    public static boolean isOverlayName(String fname) {
        if (fname == null) {
            throw new IllegalArgumentException("File name is null.");
        }
        String lcname = fname.toLowerCase();
        for (String extension : EXTENSIONS) {
            if (!lcname.endsWith(extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

