/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.BOutlineOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.overlay.TOutlineOverlay;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;

public class OverlayFactory {
    private static final Object[][] OVERLAY_CLASSES = new Object[][]{{"cno", TOutlineOverlay.class}, {"cnob", BOutlineOverlay.class}, {"gif", MaskOverlay.class}, {"png", MaskOverlay.class}};

    private OverlayFactory() {
    }

    public static boolean isOverlayName(File f) {
        return OverlayFactory.isOverlayName(f.getName());
    }

    public static boolean isOverlayName(String fname) {
        String lcname = fname.toLowerCase();
        for (Object[] oclass : OVERLAY_CLASSES) {
            if (!lcname.endsWith("." + oclass[0])) continue;
            return true;
        }
        return false;
    }

    public static AbstractOverlay create(String type) {
        Class ctClass = OverlayFactory.classForName(type);
        if (ctClass == null) {
            throw new IllegalArgumentException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractOverlay)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    public static AbstractOverlay open(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        Class ctClass = OverlayFactory.classForName(file.getName());
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{File.class};
            Object[] args = new Object[]{file};
            Constructor c = ctClass.getConstructor(types);
            AbstractOverlay ao = (AbstractOverlay)c.newInstance(args);
            return ao;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t != null) {
                t.printStackTrace();
                throw new IllegalArgumentException(t.toString());
            }
            ite.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + ite.toString());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    public static AbstractOverlay open(URL url) throws FileNotFoundException, IOException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        Class ctClass = OverlayFactory.classForName(url.getFile());
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{URL.class};
            Object[] args = new Object[]{url};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractOverlay)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    public static AbstractOverlay open(byte[] bytes, String name) throws IOException {
        Class ctClass = OverlayFactory.classForName(name);
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{byte[].class};
            Object[] args = new Object[]{bytes};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractOverlay)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    private static Class classForName(String fname) {
        String lcname = fname.toLowerCase();
        for (Object[] oclass : OVERLAY_CLASSES) {
            if (!lcname.equals((String)oclass[0]) && !lcname.endsWith("." + (String)oclass[0])) continue;
            return (Class)oclass[1];
        }
        return null;
    }

    public static String[] getValidExtensions() {
        String[] array = new String[OVERLAY_CLASSES.length];
        for (int i = 0; i < OVERLAY_CLASSES.length; ++i) {
            array[i] = (String)OVERLAY_CLASSES[i][0];
        }
        return array;
    }
}

