/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class OutlineOverlay
extends AbstractOverlay {
    protected PointLL[] points_;

    public OutlineOverlay(File f) throws IOException, FileNotFoundException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setIdentifier(f.toURI().toURL().toString());
        this.readPath(f);
    }

    public OutlineOverlay(URL url) throws IOException, FileNotFoundException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open null file");
        }
        this.setIdentifier(url.toString());
        this.readPath(url);
    }

    public OutlineOverlay(byte[] bytes, String id) throws IOException {
        this.setIdentifier(id);
        this.readPath(bytes);
    }

    private void readPath(File f) throws FileNotFoundException, IOException {
        this.readStream(new FileInputStream(f));
    }

    private void readPath(URL url) throws IOException {
        this.readStream(url.openStream());
    }

    private void readPath(byte[] bytes) throws IOException {
        this.readStream(new ByteArrayInputStream(bytes));
    }

    protected abstract void readStream(InputStream var1) throws IOException;

    public PointLL[] getPoints() {
        return this.points_;
    }
}

