/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.graphics.filters.MaskFilter;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class MaskOverlay
extends AbstractOverlay {
    private static Toolkit toolkit_ = Toolkit.getDefaultToolkit();
    private BufferedImage source_;

    public MaskOverlay(File f) throws InterruptedException, IOException, FileNotFoundException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        URL url = f.toURI().toURL();
        this.setIdentifier(url.toString());
        this.initFromLocation(url);
    }

    public MaskOverlay(URL url) throws InterruptedException, IOException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.setIdentifier(url.toString());
        this.initFromLocation(url);
    }

    public MaskOverlay(byte[] bytes, String id) throws InterruptedException {
        this.setIdentifier(id);
        this.source_ = this.image2BufferedImage(toolkit_.createImage(bytes));
    }

    private void initFromLocation(URL url) throws IllegalArgumentException, InterruptedException, IOException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.source_ = ImageIO.read(url);
        if (this.source_.getWidth() < 1 || this.source_.getHeight() < 1) {
            throw new IOException("Invalid image file");
        }
    }

    public int getWidth() {
        return this.source_.getWidth();
    }

    public int getHeight() {
        return this.source_.getHeight();
    }

    public BufferedImage getSource() {
        return this.source_;
    }

    public BufferedImage getMask(Color color) {
        return this.getMask(color, false);
    }

    public BufferedImage getMask(Color color, boolean inverted) {
        FilteredImageSource ip = new FilteredImageSource(this.source_.getSource(), new MaskFilter(color, inverted));
        return this.image2BufferedImage(toolkit_.createImage(ip));
    }

    private BufferedImage image2BufferedImage(Image img) {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public String getDescription() {
        return super.getDescription() + " mask";
    }
}

