/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class BOutlineOverlay
extends OutlineOverlay {
    public BOutlineOverlay(File f) throws IOException, FileNotFoundException {
        super(f);
    }

    public BOutlineOverlay(URL url) throws IOException, FileNotFoundException {
        super(url);
    }

    public BOutlineOverlay(byte[] bytes, String identifier) throws IOException {
        super(bytes, identifier);
    }

    protected void readStream(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte[] b = new byte[8];
        int bytesRead = is.read(b);
        if (bytesRead < 8) {
            dis.close();
            throw new IOException("Does not seem to be a CNOB file.");
        }
        String eight = new String(b);
        if (!eight.equals("GISSCNOB")) {
            dis.close();
            throw new IOException("Does not seem to be a CNOB file.");
        }
        int capacity = dis.available() / 4;
        ArrayList<PointLL> temporary = new ArrayList<PointLL>(capacity);
        try {
            boolean lastReadWasLon = false;
            int lon1000 = 0;
            int lat1000 = 0;
            while (dis.available() > 0) {
                int bTry;
                if (temporary.size() >= capacity - 500) {
                    temporary.ensureCapacity(capacity += 4000);
                }
                if ((bTry = Math.max(8192, dis.available())) % 4 > 0) {
                    bTry -= bTry % 4;
                }
                byte[] bytes = new byte[bTry];
                int bRead = dis.read(bytes);
                for (int offset = 0; offset < bRead; offset += 4) {
                    byte a = bytes[offset];
                    byte b2 = bytes[offset + 1];
                    byte c = bytes[offset + 2];
                    byte d = bytes[offset + 3];
                    int i = (a & 0xFF) << 24 | (b2 & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
                    if (i == 999999) {
                        temporary.add(null);
                        lastReadWasLon = false;
                        continue;
                    }
                    if (lastReadWasLon) {
                        lat1000 = i;
                        lastReadWasLon = false;
                        double lon = 0.001 * (double)lon1000;
                        double lat = 0.001 * (double)lat1000;
                        PointLL p = new PointLL(lon, lat);
                        temporary.add(p);
                        continue;
                    }
                    lon1000 = i;
                    lastReadWasLon = true;
                }
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        dis.close();
        this.points_ = temporary.toArray(new PointLL[0]);
    }
}

