/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.landmarks;

import gov.nasa.giss.map.landmarks.LandmarkEvent;
import gov.nasa.giss.map.landmarks.LandmarkListener;
import java.awt.Color;
import javax.swing.event.EventListenerList;

public abstract class Satellite {
    public static final int NATURAL = 101;
    public static final int MANMADE = 102;
    public static final int UNKNOWN = 99;
    private double longitude = Double.NaN;
    private double latitude = Double.NaN;
    private double altitude = Double.NaN;
    private boolean markIt;
    private int type = 99;
    private String code;
    private String name;
    private String description;
    private Color color = Color.WHITE;
    private EventListenerList listenerList_ = new EventListenerList();

    public Satellite(int type, double lon, double lat, double alt, String code, String name) {
        this(type, lon, lat, alt, code, name, Color.GREEN);
    }

    public Satellite(int type, double lon, double lat, double alt, String code, String name, Color color) {
        this.type = type;
        this.longitude = lon;
        this.latitude = lat;
        this.altitude = alt;
        this.markIt = false;
        this.code = code;
        this.name = name;
        this.color = color;
    }

    public abstract void update();

    public int getType() {
        return this.type;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double d) {
        this.altitude = d;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isMarked() {
        return this.markIt;
    }

    public void setMarked(boolean b) {
        if (b == this.markIt) {
            return;
        }
        this.markIt = b;
        this.fireLandmarkChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        if (c.equals(this.color)) {
            return;
        }
        this.color = c;
        this.fireLandmarkChanged();
    }

    public int compareTo(Satellite other) {
        if (this.type > other.getType()) {
            return 1;
        }
        if (this.type < other.getType()) {
            return -1;
        }
        return this.name.compareTo(other.getName());
    }

    public synchronized void addLandmarkListener(LandmarkListener l) {
        this.listenerList_.add(LandmarkListener.class, l);
    }

    public synchronized void removeLandmarkListener(LandmarkListener l) {
        this.listenerList_.remove(LandmarkListener.class, l);
    }

    private void fireLandmarkChanged() {
        LandmarkEvent e = new LandmarkEvent(this, 1);
        for (LandmarkListener ll : (LandmarkListener[])this.listenerList_.getListeners(LandmarkListener.class)) {
            ll.landmarkChanged(e);
        }
    }
}

