/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.landmarks;

import gov.nasa.giss.map.landmarks.Landmark;
import gov.nasa.giss.xml.EasyParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LandmarkList
extends ArrayList<Landmark> {
    private String version_;
    private double oblate_;

    private LandmarkList() {
    }

    public LandmarkList(File f) throws FileNotFoundException, IOException, JDOMException {
        super(50);
        this.buildFromStream(new FileInputStream(f));
    }

    public LandmarkList(URL urlBase, String fname) throws IOException, JDOMException, MalformedURLException {
        this(new URL(urlBase, fname));
    }

    public LandmarkList(URL url) throws IOException, JDOMException {
        this.buildFromStream(url.openStream());
    }

    public LandmarkList(InputStream is) throws IOException, JDOMException {
        this.buildFromStream(is);
    }

    private void buildFromStream(InputStream is) throws IOException, JDOMException {
        Document document = EasyParser.parseDocument(is);
        Element root = document.getRootElement();
        if (!root.getName().equals("landmarklist")) {
            throw new IllegalArgumentException("File root element is not 'landmarklist'.");
        }
        for (Element child : root.getChildren()) {
            Attribute value;
            String childName = child.getName();
            if (childName.equals("version")) {
                value = child.getAttribute("value");
                if (value == null) continue;
                this.version_ = value.getValue();
                continue;
            }
            if (!childName.equals("oblate") || (value = child.getAttribute("value")) == null) continue;
            try {
                this.oblate_ = value.getDoubleValue();
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("Bad longitude data in oblatness field " + value.getValue());
            }
        }
        for (Element child : root.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("landmark")) continue;
            try {
                this.add(new Landmark(child, this.oblate_));
            }
            catch (Exception exc) {
                System.err.println("WARNING: Landmark error : " + exc.toString());
            }
        }
        this.sortByName();
    }

    public int count() {
        return this.size();
    }

    public void sortByType() {
        Comparator compare = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Landmark)o1).compareByType((Landmark)o2);
            }
        };
        Collections.sort(this, compare);
    }

    public void sortByName() {
        Comparator compare = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Landmark)o1).compareByName((Landmark)o2);
            }
        };
        Collections.sort(this, compare);
    }

    public Landmark findByName(String lname) {
        for (int i = 0; i < this.count(); ++i) {
            Landmark l = (Landmark)this.get(i);
            if (lname.indexOf(l.getName()) <= -1) continue;
            return l;
        }
        return null;
    }

    public Landmark findByCode(String lcode) {
        for (int i = 0; i < this.count(); ++i) {
            Landmark l = (Landmark)this.get(i);
            if (!lcode.equals(l.getCode())) continue;
            return l;
        }
        return null;
    }
}

