/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.landmarks;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.CoordinateSystem;
import gov.nasa.giss.map.landmarks.LandmarkEvent;
import gov.nasa.giss.map.landmarks.LandmarkListener;
import gov.nasa.giss.map.landmarks.LandmarkType;
import java.awt.Color;
import javax.swing.event.EventListenerList;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class Landmark {
    private double oblate_;
    private PointLL lonlatPG_;
    private PointLL lonlatPC_;
    private boolean markIt_;
    private LandmarkType type_ = LandmarkType.UNKNOWN;
    private String code_;
    private String name_;
    private String description_;
    private Color color_ = this.type_.getColor();
    private EventListenerList listenerList_ = new EventListenerList();

    public Landmark(Element node) {
        this(node, 0.0);
    }

    public Landmark(Element node, double oblate) {
        this.oblate_ = oblate;
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if (childName.equals("name")) {
                this.name_ = child.getText();
                continue;
            }
            if (childName.equals("code")) {
                this.code_ = child.getText();
                continue;
            }
            if (childName.equals("coords")) {
                Attribute scheme = child.getAttribute("scheme");
                Attribute lonAtt = child.getAttribute("lon");
                Attribute latAtt = child.getAttribute("lat");
                double lon = 0.0;
                try {
                    lon = lonAtt != null ? lonAtt.getDoubleValue() : 0.0;
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Bad longitude attribute in coords : " + lonAtt.getValue());
                }
                double lat = 0.0;
                try {
                    lat = latAtt != null ? latAtt.getDoubleValue() : 0.0;
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Bad latitude attribute in coords : " + latAtt.getValue());
                }
                try {
                    if (scheme != null) {
                        String s = scheme.getValue().toLowerCase();
                        if (s.equals("pc") || s.indexOf("centric") > -1) {
                            this.lonlatPC_ = new PointLL(lon, lat);
                            continue;
                        }
                        if (s.equals("pg") || s.indexOf("graphic") > -1) {
                            this.lonlatPG_ = new PointLL(lon, lat);
                            continue;
                        }
                        throw new IllegalArgumentException("Bad scheme attribute in coords");
                    }
                    this.lonlatPG_ = new PointLL(lon, lat);
                    continue;
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Bad scheme attribute in coords");
                }
            }
            if (childName.equals("type")) {
                String value = child.getText();
                if (value.indexOf("active lander") > -1) {
                    this.type_ = LandmarkType.ACTIVE_LANDER;
                } else if (value.indexOf("planned lander") > -1) {
                    this.type_ = LandmarkType.PLANNED_LANDER;
                } else if (value.indexOf("crash site") > -1) {
                    this.type_ = LandmarkType.CRASH_SITE;
                } else if (value.indexOf("lander") > -1) {
                    this.type_ = LandmarkType.PAST_LANDER;
                } else if (value.indexOf("surface feature") > -1) {
                    this.type_ = LandmarkType.FEATURE;
                } else if (value.indexOf("region") > -1) {
                    this.type_ = LandmarkType.REGION;
                }
                if (this.type_ == null) continue;
                this.color_ = this.type_.getColor();
                continue;
            }
            if (childName.equals("notes")) {
                this.description_ = child.getText();
                continue;
            }
            if (childName.equals("longitude")) {
                if (this.lonlatPG_ == null) {
                    this.lonlatPG_ = new PointLL();
                }
                try {
                    this.lonlatPG_.setLon(Double.parseDouble(child.getText()));
                    continue;
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Bad CDATA in longitude");
                }
            }
            if (!childName.equals("latitude")) continue;
            if (this.lonlatPG_ == null) {
                this.lonlatPG_ = new PointLL();
            }
            try {
                this.lonlatPG_.setLat(Double.parseDouble(child.getText()));
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("Bad CDATA in latitude");
            }
        }
        this.convertCoords();
        if (this.code_ == null) {
            this.code_ = "XXX";
        }
        if (this.name_ == null) {
            this.name_ = "Unnamed site";
        }
    }

    public Landmark(LandmarkType type, double lon, double lat, String code, String name) {
        this(type, lon, lat, code, name, Color.GREEN);
    }

    public Landmark(LandmarkType type, double lon, double lat, String code, String name, Color color) {
        this.type_ = type;
        this.markIt_ = false;
        this.code_ = code;
        this.name_ = name;
        this.color_ = color;
        this.lonlatPG_ = new PointLL(lon, lat);
        this.convertCoords();
    }

    private void convertCoords() {
        if (this.lonlatPC_ == null && this.lonlatPG_ == null) {
            throw new IllegalArgumentException("Cannot convert coordinates: both p'c and p'g are null");
        }
        if (this.lonlatPC_ != null && this.lonlatPG_ != null) {
            System.err.println("MESSAGE: No conversion needed. Both p's and p'g coordinates are set.");
        }
        if (this.oblate_ == 0.0) {
            if (this.lonlatPG_ != null) {
                this.lonlatPC_ = new PointLL(-this.lonlatPG_.getLon(), this.lonlatPG_.getLat());
            } else {
                this.lonlatPG_ = new PointLL(-this.lonlatPC_.getLon(), this.lonlatPC_.getLat());
            }
        } else if (this.lonlatPG_ != null) {
            double lat = this.lonlatPG_.getLat();
            if (lat == 0.0 || Math.abs(lat) == 90.0) {
                this.lonlatPC_ = new PointLL(-this.lonlatPG_.getLon(), this.lonlatPG_.getLat());
            } else {
                double latPC = Math.toDegrees(Math.atan(Math.tan(Math.toRadians(lat)) * ((1.0 - this.oblate_) * (1.0 - this.oblate_))));
                this.lonlatPC_ = new PointLL(-this.lonlatPG_.getLon(), latPC);
            }
        } else {
            double lat = this.lonlatPC_.getLat();
            if (lat == 0.0 || Math.abs(lat) == 90.0) {
                this.lonlatPG_ = new PointLL(-this.lonlatPC_.getLon(), this.lonlatPC_.getLat());
            } else {
                double latPG = Math.toDegrees(Math.atan(Math.tan(Math.toRadians(lat)) / ((1.0 - this.oblate_) * (1.0 - this.oblate_))));
                this.lonlatPG_ = new PointLL(-this.lonlatPC_.getLon(), latPG);
            }
        }
    }

    public LandmarkType getType() {
        return this.type_;
    }

    public PointLL getPoint(CoordinateSystem csystem) {
        return csystem == CoordinateSystem.PLANETOGRAPHIC ? this.lonlatPG_.copy() : this.lonlatPC_.copy();
    }

    public double getLon(CoordinateSystem csystem) {
        double lon;
        double d = lon = csystem == CoordinateSystem.PLANETOGRAPHIC ? this.lonlatPG_.getLon() : this.lonlatPC_.getLon();
        while (lon < 0.0) {
            lon += 360.0;
        }
        while (lon >= 360.0) {
            lon -= 360.0;
        }
        return lon;
    }

    public double getLat(CoordinateSystem csystem) {
        return csystem == CoordinateSystem.PLANETOGRAPHIC ? this.lonlatPG_.getLat() : this.lonlatPC_.getLat();
    }

    public String getName() {
        return this.name_;
    }

    public String getCode() {
        return this.code_;
    }

    public boolean isMarked() {
        return this.markIt_;
    }

    public void setMarked(boolean b) {
        if (b == this.markIt_) {
            return;
        }
        this.markIt_ = b;
        this.fireLandmarkChanged();
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color c) {
        if (c.equals(this.color_)) {
            return;
        }
        this.color_ = c;
        this.fireLandmarkChanged();
    }

    public int compareTo(Landmark other) {
        return this.compareByType(other);
    }

    public int compareByType(Landmark other) {
        int i2;
        int i1 = this.type_.getSortOrder();
        if (i1 > (i2 = other.getType().getSortOrder())) {
            return 1;
        }
        if (i1 < i2) {
            return -1;
        }
        return this.compareByName(other);
    }

    public int compareByName(Landmark other) {
        return this.name_.compareTo(other.getName());
    }

    public synchronized void addLandmarkListener(LandmarkListener l) {
        this.listenerList_.add(LandmarkListener.class, l);
    }

    public synchronized void removeLandmarkListener(LandmarkListener l) {
        this.listenerList_.remove(LandmarkListener.class, l);
    }

    private void fireLandmarkChanged() {
        LandmarkEvent e = new LandmarkEvent(this, 1);
        for (LandmarkListener ll : (LandmarkListener[])this.listenerList_.getListeners(LandmarkListener.class)) {
            ll.landmarkChanged(e);
        }
    }
}

