/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Airy;
import gov.nasa.giss.map.proj.Aitoff;
import gov.nasa.giss.map.proj.AlbersEqualAreaConic;
import gov.nasa.giss.map.proj.Apian2;
import gov.nasa.giss.map.proj.AzimuthalEqualArea;
import gov.nasa.giss.map.proj.AzimuthalEquidistant;
import gov.nasa.giss.map.proj.BaconGlobular;
import gov.nasa.giss.map.proj.BakerDinomic;
import gov.nasa.giss.map.proj.BoggsEumorphic;
import gov.nasa.giss.map.proj.Bonne;
import gov.nasa.giss.map.proj.BraunPerspective;
import gov.nasa.giss.map.proj.BraunStereographic;
import gov.nasa.giss.map.proj.BreusingGeometric;
import gov.nasa.giss.map.proj.BreusingHarmonic;
import gov.nasa.giss.map.proj.CantersPolyconic1989f9;
import gov.nasa.giss.map.proj.CantersPseudocylindric2002f518;
import gov.nasa.giss.map.proj.CantersPseudocylindric2002f519;
import gov.nasa.giss.map.proj.CantersPseudocylindric2002f520;
import gov.nasa.giss.map.proj.CantersPseudocylindric2002f523;
import gov.nasa.giss.map.proj.CylindricalEqualArea;
import gov.nasa.giss.map.proj.Denoyer;
import gov.nasa.giss.map.proj.Eckert3;
import gov.nasa.giss.map.proj.Eckert4;
import gov.nasa.giss.map.proj.Eckert5;
import gov.nasa.giss.map.proj.Eckert6;
import gov.nasa.giss.map.proj.EckertGreifendorff;
import gov.nasa.giss.map.proj.EquidistantConic;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularOblique;
import gov.nasa.giss.map.proj.ErdiKrausz;
import gov.nasa.giss.map.proj.Fahey;
import gov.nasa.giss.map.proj.Foucaut;
import gov.nasa.giss.map.proj.Fournier1;
import gov.nasa.giss.map.proj.GallStereographic;
import gov.nasa.giss.map.proj.Ginzburg4;
import gov.nasa.giss.map.proj.Ginzburg5;
import gov.nasa.giss.map.proj.Ginzburg6;
import gov.nasa.giss.map.proj.Ginzburg8;
import gov.nasa.giss.map.proj.Ginzburg9;
import gov.nasa.giss.map.proj.Gnomonic;
import gov.nasa.giss.map.proj.GnomonicCubedSphere;
import gov.nasa.giss.map.proj.GoodeHomolosine;
import gov.nasa.giss.map.proj.GottEqualArea;
import gov.nasa.giss.map.proj.GottMugnoloAzimuthal;
import gov.nasa.giss.map.proj.Gringorten;
import gov.nasa.giss.map.proj.Hammer;
import gov.nasa.giss.map.proj.HillEucyclic;
import gov.nasa.giss.map.proj.Hoelzel;
import gov.nasa.giss.map.proj.Kavraisky5;
import gov.nasa.giss.map.proj.Kavraisky7;
import gov.nasa.giss.map.proj.LambertConformalConic;
import gov.nasa.giss.map.proj.Larrivee;
import gov.nasa.giss.map.proj.MTFlatPolarParabolic;
import gov.nasa.giss.map.proj.MTFlatPolarQuartic;
import gov.nasa.giss.map.proj.MTFlatPolarSinusoidal;
import gov.nasa.giss.map.proj.Mayr;
import gov.nasa.giss.map.proj.McBrydeP3;
import gov.nasa.giss.map.proj.McBrydeQ3;
import gov.nasa.giss.map.proj.McBrydeS2;
import gov.nasa.giss.map.proj.McBrydeS3;
import gov.nasa.giss.map.proj.McBrydeThomasSine1;
import gov.nasa.giss.map.proj.Mercator;
import gov.nasa.giss.map.proj.MillerCylindric;
import gov.nasa.giss.map.proj.ModifiedGall;
import gov.nasa.giss.map.proj.Mollweide;
import gov.nasa.giss.map.proj.Nell;
import gov.nasa.giss.map.proj.NellHammer;
import gov.nasa.giss.map.proj.OrteliusOval;
import gov.nasa.giss.map.proj.Orthographic;
import gov.nasa.giss.map.proj.Parabolic;
import gov.nasa.giss.map.proj.Pavlov;
import gov.nasa.giss.map.proj.PutninsP1;
import gov.nasa.giss.map.proj.PutninsP2;
import gov.nasa.giss.map.proj.PutninsP3;
import gov.nasa.giss.map.proj.PutninsP3p;
import gov.nasa.giss.map.proj.PutninsP4p;
import gov.nasa.giss.map.proj.PutninsP5;
import gov.nasa.giss.map.proj.PutninsP5p;
import gov.nasa.giss.map.proj.PutninsP6;
import gov.nasa.giss.map.proj.PutninsP6P;
import gov.nasa.giss.map.proj.QuarticAuthalic;
import gov.nasa.giss.map.proj.RaiszArmadillo;
import gov.nasa.giss.map.proj.RaiszHalfEllipsoidal;
import gov.nasa.giss.map.proj.Robinson;
import gov.nasa.giss.map.proj.Sinusoidal;
import gov.nasa.giss.map.proj.Stereographic;
import gov.nasa.giss.map.proj.TimesAtlas;
import gov.nasa.giss.map.proj.ToblerG1;
import gov.nasa.giss.map.proj.UrmayevSinusoidal;
import gov.nasa.giss.map.proj.VanDerGrinten1;
import gov.nasa.giss.map.proj.VerticalPerspective;
import gov.nasa.giss.map.proj.Wagner1;
import gov.nasa.giss.map.proj.Wagner2;
import gov.nasa.giss.map.proj.Wagner3;
import gov.nasa.giss.map.proj.Wagner4;
import gov.nasa.giss.map.proj.Wagner5;
import gov.nasa.giss.map.proj.Wagner6;
import gov.nasa.giss.map.proj.Wagner7;
import gov.nasa.giss.map.proj.Wagner8;
import gov.nasa.giss.map.proj.Wagner9;
import gov.nasa.giss.map.proj.Winkel1;
import gov.nasa.giss.map.proj.Winkel2;
import gov.nasa.giss.map.proj.WinkelTripel;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class ProjectionFactory {
    private static final boolean DEVO = false;
    private static ArrayList<ProjectionInfo> infoArray_ = new ArrayList(125);
    private static String[] sortedNames_;

    private ProjectionFactory() {
    }

    public static boolean registerProjection(Class pclass) {
        try {
            Field nameField = pclass.getField("PROJECTION_NAME");
            String name = nameField.get(null).toString();
            infoArray_.add(new ProjectionInfo(name, pclass));
            return true;
        }
        catch (Exception exc) {
            System.out.println("ERROR: Couldn't set up projection " + pclass);
            return false;
        }
    }

    public static AbstractProjection create(String name, int w, int h) {
        return ProjectionFactory.create(name, w, h, 0, 0);
    }

    public static AbstractProjection create(String name, int w, int h, int xmargin, int ymargin) {
        ProjectionInfo pinfo = ProjectionFactory.getInfoForName(name);
        if (pinfo == null) {
            throw new IllegalArgumentException("Unknown projection");
        }
        if (xmargin < 0 || ymargin < 0) {
            throw new IllegalArgumentException("Invalid margin(s).");
        }
        if (w < 2 * xmargin + 1) {
            throw new IllegalArgumentException("Invalid map width.");
        }
        if (h < 2 * ymargin + 1) {
            throw new IllegalArgumentException("Invalid map height.");
        }
        try {
            Class aClass = pinfo.getPClass();
            Class[] types = new Class[]{Dimension.class, Dimension.class};
            Object[] args = new Object[]{new Dimension(w, h), new Dimension(xmargin, ymargin)};
            Constructor c = aClass.getConstructor(types);
            return (AbstractProjection)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Projection construction error!");
        }
    }

    public static String[] getNames() {
        return ProjectionFactory.getNames(0);
    }

    public static String[] getNames(int property) {
        int isize = infoArray_.size();
        Collator collator = Collator.getInstance();
        Vector<CollationKey> names = new Vector<CollationKey>(isize);
        for (ProjectionInfo pi : infoArray_) {
            if (property != 0 && !pi.hasProperty(property)) continue;
            names.add(collator.getCollationKey(pi.getName()));
        }
        Comparator keyComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                CollationKey k1 = (CollationKey)o1;
                CollationKey k2 = (CollationKey)o2;
                return k1.compareTo(k2);
            }
        };
        Collections.sort(names, keyComparator);
        String[] sortedNames = new String[isize];
        for (int i = 0; i < isize; ++i) {
            sortedNames[i] = ((CollationKey)names.get(i)).getSourceString();
        }
        return sortedNames;
    }

    private static ProjectionInfo getInfoForName(String name) {
        if (name == null) {
            return null;
        }
        for (ProjectionInfo pi : infoArray_) {
            if (!pi.getName().equalsIgnoreCase(name)) continue;
            return pi;
        }
        return null;
    }

    private static boolean hasProperty(String pname, int pvalue) {
        ProjectionInfo pi = ProjectionFactory.getInfoForName(pname);
        if (pi == null) {
            throw new IllegalArgumentException("Unknown projection");
        }
        return pi.hasProperty(pvalue);
    }

    private static boolean hasProperty(ProjectionInfo pi, int pvalue) {
        if (pi == null) {
            throw new IllegalArgumentException("Unknown projection");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Field field = pi.getPClass().getField("PROPERTIES");
            return ((Integer)field.get(null) & pvalue) != 0;
        }
        catch (Exception exc) {
            System.out.println("ERROR: Property test failed; returning false");
            return false;
        }
    }

    public static boolean isOblique(String pname) {
        return ProjectionFactory.hasProperty(pname, 131072);
    }

    public static boolean isConic(String pname) {
        return ProjectionFactory.hasProperty(pname, 8);
    }

    public static boolean isInterrupted(String pname) {
        return ProjectionFactory.hasProperty(pname, 524288);
    }

    static {
        ProjectionFactory.registerProjection(Equirectangular.class);
        ProjectionFactory.registerProjection(Orthographic.class);
        ProjectionFactory.registerProjection(Mollweide.class);
        ProjectionFactory.registerProjection(Stereographic.class);
        ProjectionFactory.registerProjection(Aitoff.class);
        ProjectionFactory.registerProjection(AzimuthalEquidistant.class);
        ProjectionFactory.registerProjection(AzimuthalEqualArea.class);
        ProjectionFactory.registerProjection(Hammer.class);
        ProjectionFactory.registerProjection(Sinusoidal.class);
        ProjectionFactory.registerProjection(Parabolic.class);
        ProjectionFactory.registerProjection(Eckert4.class);
        ProjectionFactory.registerProjection(Eckert6.class);
        ProjectionFactory.registerProjection(Eckert5.class);
        ProjectionFactory.registerProjection(EckertGreifendorff.class);
        ProjectionFactory.registerProjection(QuarticAuthalic.class);
        ProjectionFactory.registerProjection(MTFlatPolarQuartic.class);
        ProjectionFactory.registerProjection(MTFlatPolarSinusoidal.class);
        ProjectionFactory.registerProjection(MTFlatPolarParabolic.class);
        ProjectionFactory.registerProjection(Eckert3.class);
        ProjectionFactory.registerProjection(Wagner4.class);
        ProjectionFactory.registerProjection(Kavraisky7.class);
        ProjectionFactory.registerProjection(PutninsP3.class);
        ProjectionFactory.registerProjection(PutninsP3p.class);
        ProjectionFactory.registerProjection(PutninsP5.class);
        ProjectionFactory.registerProjection(PutninsP5p.class);
        ProjectionFactory.registerProjection(NellHammer.class);
        ProjectionFactory.registerProjection(Wagner1.class);
        ProjectionFactory.registerProjection(PutninsP4p.class);
        ProjectionFactory.registerProjection(Winkel1.class);
        ProjectionFactory.registerProjection(Wagner2.class);
        ProjectionFactory.registerProjection(Wagner5.class);
        ProjectionFactory.registerProjection(WinkelTripel.class);
        ProjectionFactory.registerProjection(Mercator.class);
        ProjectionFactory.registerProjection(MillerCylindric.class);
        ProjectionFactory.registerProjection(GallStereographic.class);
        ProjectionFactory.registerProjection(OrteliusOval.class);
        ProjectionFactory.registerProjection(VanDerGrinten1.class);
        ProjectionFactory.registerProjection(VerticalPerspective.class);
        ProjectionFactory.registerProjection(Wagner7.class);
        ProjectionFactory.registerProjection(Wagner8.class);
        ProjectionFactory.registerProjection(Apian2.class);
        ProjectionFactory.registerProjection(PutninsP1.class);
        ProjectionFactory.registerProjection(Wagner6.class);
        ProjectionFactory.registerProjection(Hoelzel.class);
        ProjectionFactory.registerProjection(McBrydeP3.class);
        ProjectionFactory.registerProjection(McBrydeQ3.class);
        ProjectionFactory.registerProjection(McBrydeS2.class);
        ProjectionFactory.registerProjection(GoodeHomolosine.class);
        ProjectionFactory.registerProjection(McBrydeS3.class);
        ProjectionFactory.registerProjection(CantersPseudocylindric2002f523.class);
        ProjectionFactory.registerProjection(CantersPseudocylindric2002f518.class);
        ProjectionFactory.registerProjection(CantersPseudocylindric2002f520.class);
        ProjectionFactory.registerProjection(CantersPseudocylindric2002f519.class);
        ProjectionFactory.registerProjection(Foucaut.class);
        ProjectionFactory.registerProjection(McBrydeThomasSine1.class);
        ProjectionFactory.registerProjection(Kavraisky5.class);
        ProjectionFactory.registerProjection(Denoyer.class);
        ProjectionFactory.registerProjection(Winkel2.class);
        ProjectionFactory.registerProjection(ErdiKrausz.class);
        ProjectionFactory.registerProjection(Wagner9.class);
        ProjectionFactory.registerProjection(RaiszArmadillo.class);
        ProjectionFactory.registerProjection(Wagner3.class);
        ProjectionFactory.registerProjection(CantersPolyconic1989f9.class);
        ProjectionFactory.registerProjection(RaiszHalfEllipsoidal.class);
        ProjectionFactory.registerProjection(Robinson.class);
        ProjectionFactory.registerProjection(PutninsP2.class);
        ProjectionFactory.registerProjection(PutninsP6.class);
        ProjectionFactory.registerProjection(PutninsP6P.class);
        ProjectionFactory.registerProjection(TimesAtlas.class);
        ProjectionFactory.registerProjection(ModifiedGall.class);
        ProjectionFactory.registerProjection(Pavlov.class);
        ProjectionFactory.registerProjection(CylindricalEqualArea.class);
        ProjectionFactory.registerProjection(Ginzburg8.class);
        ProjectionFactory.registerProjection(Larrivee.class);
        ProjectionFactory.registerProjection(BakerDinomic.class);
        ProjectionFactory.registerProjection(EquidistantConic.class);
        ProjectionFactory.registerProjection(AlbersEqualAreaConic.class);
        ProjectionFactory.registerProjection(LambertConformalConic.class);
        ProjectionFactory.registerProjection(UrmayevSinusoidal.class);
        ProjectionFactory.registerProjection(BoggsEumorphic.class);
        ProjectionFactory.registerProjection(Nell.class);
        ProjectionFactory.registerProjection(Fahey.class);
        ProjectionFactory.registerProjection(Bonne.class);
        ProjectionFactory.registerProjection(BraunStereographic.class);
        ProjectionFactory.registerProjection(BraunPerspective.class);
        ProjectionFactory.registerProjection(HillEucyclic.class);
        ProjectionFactory.registerProjection(Fournier1.class);
        ProjectionFactory.registerProjection(BaconGlobular.class);
        ProjectionFactory.registerProjection(GottEqualArea.class);
        ProjectionFactory.registerProjection(Mayr.class);
        ProjectionFactory.registerProjection(ToblerG1.class);
        ProjectionFactory.registerProjection(Gringorten.class);
        ProjectionFactory.registerProjection(Gnomonic.class);
        ProjectionFactory.registerProjection(GnomonicCubedSphere.class);
        ProjectionFactory.registerProjection(GottMugnoloAzimuthal.class);
        ProjectionFactory.registerProjection(EquirectangularOblique.class);
        ProjectionFactory.registerProjection(Airy.class);
        ProjectionFactory.registerProjection(BreusingGeometric.class);
        ProjectionFactory.registerProjection(BreusingHarmonic.class);
        ProjectionFactory.registerProjection(Ginzburg4.class);
        ProjectionFactory.registerProjection(Ginzburg5.class);
        ProjectionFactory.registerProjection(Ginzburg6.class);
        ProjectionFactory.registerProjection(Ginzburg9.class);
    }

    static class ProjectionInfo {
        private String ppname_;
        private Class ppclass_;

        ProjectionInfo(String pname, Class pclass) {
            this.ppname_ = pname;
            this.ppclass_ = pclass;
        }

        String getName() {
            return this.ppname_;
        }

        Class getPClass() {
            return this.ppclass_;
        }

        boolean hasProperty(int pvalue) {
            try {
                Class[] types = new Class[]{};
                Object[] args = new Object[]{};
                Field field = this.getPClass().getField("PROPERTIES");
                return ((Integer)field.get(null) & pvalue) != 0;
            }
            catch (Exception exc) {
                System.out.println("ERROR: Property test failed; returning false");
                return false;
            }
        }
    }
}

