/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.img.ImageUtilities;
import gov.nasa.giss.xml.EasyParser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class KmlData {
    private static final boolean DEBUG = false;
    private static final String KML_EXT = "kml";
    private static final String KMZ_EXT = "kmz";
    private static final String DOT_KML = ".kml";
    private static final String DOT_KMZ = ".kmz";
    private File rootFile_;
    private boolean rootIsKmz_;
    private String imageHref_;
    private double north_ = Double.NaN;
    private double east_ = Double.NaN;
    private double south_ = Double.NaN;
    private double west_ = Double.NaN;
    private double rotation_ = Double.NaN;
    private BufferedImage image_;

    public KmlData(File f) {
        this.rootFile_ = f;
        String lcname = this.rootFile_.getName().toLowerCase();
        this.rootIsKmz_ = lcname.endsWith(DOT_KMZ);
    }

    public BufferedImage getGroundOverlay() throws IOException, MalformedURLException {
        if (this.image_ != null) {
            return this.image_;
        }
        if (this.imageHref_ == null) {
            throw new RuntimeException("No ground overlay Icon found in KML data");
        }
        if (this.imageHref_.startsWith("http:") || this.imageHref_.startsWith("https:") || this.imageHref_.startsWith("ftp:") || this.imageHref_.startsWith("file:")) {
            URL url = new URL(this.imageHref_);
            InputStream is = url.openStream();
            this.image_ = ImageIO.read(is);
        }
        if (this.rootIsKmz_) {
            ZipFile zf = new ZipFile(this.rootFile_);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (!ze.getName().equals(this.imageHref_)) continue;
                InputStream zis = zf.getInputStream(ze);
                this.image_ = ImageIO.read(zis);
                return this.image_;
            }
            throw new FileNotFoundException("No matching Icon image file found in KMZ file");
        }
        String path = this.rootFile_.getParentFile().getAbsolutePath();
        File imgFile = new File(path, this.imageHref_);
        if (!imgFile.exists()) {
            throw new FileNotFoundException("No image file found at " + this.imageHref_);
        }
        this.image_ = ImageUtilities.toBufferedImage(imgFile);
        return this.image_;
    }

    public double[] getBounds() {
        return new double[]{this.north_, this.east_, this.south_, this.west_};
    }

    public double getNorth() {
        return this.north_;
    }

    public double getEast() {
        return this.east_;
    }

    public double getSouth() {
        return this.south_;
    }

    public double getWest() {
        return this.west_;
    }

    public double getRotation() {
        return this.rotation_;
    }

    public void parse() throws IOException, JDOMException, ParseException {
        if (this.rootIsKmz_) {
            ZipFile zf = new ZipFile(this.rootFile_);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String lcname = ze.getName().toLowerCase();
                if (!lcname.endsWith(DOT_KML)) continue;
                this.parseKml(zf.getInputStream(ze));
                break;
            }
        } else {
            this.parseKml(new FileInputStream(this.rootFile_));
        }
    }

    private void parseKml(InputStream is) throws IOException, JDOMException, ParseException {
        Document doc = EasyParser.parseDocument(is);
        Element root = doc.getRootElement();
        this.parseElement(root);
    }

    private void parseElement(Element elem) throws IOException, JDOMException, NumberFormatException, ParseException {
        if (this.imageHref_ != null) {
            return;
        }
        Element go = null;
        for (Element child : elem.getChildren()) {
            String childName = child.getName();
            if (childName.equals("GroundOverlay")) {
                go = child;
                break;
            }
            if (!childName.equals("Folder") && !childName.equals("Document")) continue;
            this.parseElement(child);
        }
        if (go == null) {
            throw new ParseException("No GroundOverlay tag found in KML file", 0);
        }
        Element box = null;
        Element icon = null;
        for (Element child : go.getChildren()) {
            String childName = child.getName();
            if (childName.equals("Icon")) {
                icon = child;
                continue;
            }
            if (!childName.equals("LatLonBox")) continue;
            box = child;
        }
        if (icon == null) {
            throw new ParseException("No Icon tag found in KML file", 0);
        }
        if (box == null) {
            throw new ParseException("No LatLonBox tag found in KML file", 0);
        }
        Object iconLink = null;
        for (Element child : icon.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("href")) continue;
            this.imageHref_ = child.getText();
        }
        double north = Double.NaN;
        double east = Double.NaN;
        double south = Double.NaN;
        double west = Double.NaN;
        for (Element child : box.getChildren()) {
            String childName = child.getName();
            if (childName.equals("north")) {
                this.north_ = Double.parseDouble(child.getText());
                continue;
            }
            if (childName.equals("east")) {
                this.east_ = Double.parseDouble(child.getText());
                continue;
            }
            if (childName.equals("south")) {
                this.south_ = Double.parseDouble(child.getText());
                continue;
            }
            if (childName.equals("west")) {
                this.west_ = Double.parseDouble(child.getText());
                continue;
            }
            if (!childName.equals("rotation")) continue;
            this.rotation_ = Double.parseDouble(child.getText());
        }
    }
}

