/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class DayNightMap
extends Component {
    public static final double PI = Math.PI;
    public static final double RAD_PER_DEG = Math.PI / 180;
    private static final double UNKNOWN = 9999.0;
    private static final int TRANSPARENT_RGB = new Color(0, 0, 0, 0).getRGB();
    private Image sourceImage_;
    private BufferedImage targetImage_;
    private BufferedImage simpleShadow_;
    private int srcWidth_ = 2;
    private int srcHeight_ = 1;
    private int outWidth_;
    private int outHeight_;
    private int shadowWidth_;
    private int shadowHeight_;
    private int maxOpaque_;
    private double maxOpaqueF_;
    private Color shade_;
    private double pixPerDeg_;
    private double degPerPix_;
    private int darkSkip_;
    private double[] mapLon_;
    private double[] mapLat_;
    private double[] cosMapColat_;
    private double[] sinMapColat_;
    private double[][] cosC_;
    private double[] cosDTheta_;
    private static final double BRIGHT_COS = 0.2;
    private double subsolarLon_;
    private double subsolarLat_;
    private double cosSubsolarColat_;
    private double sinSubsolarColat_;
    private boolean redrawNeeded_ = true;

    public DayNightMap(Image img, int width, int height) {
        this.setSource(img);
        this.outWidth_ = width;
        this.outHeight_ = height;
        if (this.outWidth_ < 1441) {
            this.shadowWidth_ = this.outWidth_;
            this.shadowHeight_ = this.outHeight_;
        } else {
            this.shadowWidth_ = 1440;
            this.shadowHeight_ = 720;
        }
        this.simpleShadow_ = new BufferedImage(this.shadowWidth_, this.shadowHeight_, 2);
        this.targetImage_ = new BufferedImage(this.outWidth_, this.outHeight_, 2);
        this.pixPerDeg_ = (double)this.shadowWidth_ / 360.0;
        this.degPerPix_ = 1.0 / this.pixPerDeg_;
        this.darkSkip_ = this.shadowWidth_ / 6;
        this.cosDTheta_ = new double[this.shadowWidth_ + 1];
        this.cosC_ = new double[this.shadowHeight_ + 1][this.shadowWidth_ + 1];
        this.mapLon_ = new double[this.shadowWidth_ + 1];
        this.mapLat_ = new double[this.shadowHeight_ + 1];
        this.cosMapColat_ = new double[this.shadowHeight_ + 1];
        this.sinMapColat_ = new double[this.shadowHeight_ + 1];
        for (int i = 0; i <= this.shadowWidth_; ++i) {
            this.mapLon_[i] = this.degPerPix_ * (double)i - 180.0;
        }
        for (int j = 0; j <= this.shadowHeight_; ++j) {
            double mapColat = this.degPerPix_ * (double)j;
            this.mapLat_[j] = 90.0 - mapColat;
            this.cosMapColat_[j] = Math.cos(mapColat * (Math.PI / 180));
            this.sinMapColat_[j] = Math.sin(mapColat * (Math.PI / 180));
        }
        this.setSubsolarPoint(0.0, 0.0);
        this.setDarkness(153);
    }

    public void setSource(Image img) {
        this.sourceImage_ = img;
        if (this.sourceImage_ == null) {
            this.srcWidth_ = 200;
            this.srcHeight_ = 100;
        } else {
            this.srcWidth_ = this.sourceImage_.getWidth(this);
            this.srcHeight_ = this.sourceImage_.getHeight(this);
        }
        this.redrawNeeded_ = true;
    }

    public int getDarkness() {
        return this.maxOpaque_;
    }

    public void setDarkness(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Darkness must be in range 0.0 to 1.0.");
        }
        this.setDarkness((int)(value * 255.0));
    }

    public void setDarkness(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Darkness must be in range 0 to 255.");
        }
        this.maxOpaque_ = value;
        this.maxOpaqueF_ = this.maxOpaque_;
        this.shade_ = new Color(0, 0, 0, this.maxOpaque_);
        this.redrawNeeded_ = true;
    }

    public void setSubsolarPoint(double lon, double lat) {
        this.subsolarLon_ = lon;
        this.subsolarLat_ = lat;
        this.cosSubsolarColat_ = Math.cos((90.0 - this.subsolarLat_) * (Math.PI / 180));
        this.sinSubsolarColat_ = Math.sin((90.0 - this.subsolarLat_) * (Math.PI / 180));
        this.redrawNeeded_ = true;
    }

    public BufferedImage getMap() {
        if (this.redrawNeeded_) {
            this.drawMap();
        }
        return this.targetImage_;
    }

    private void drawMap() {
        int j;
        int i;
        Graphics2D shadowG2D = (Graphics2D)this.simpleShadow_.getGraphics();
        for (i = 0; i < this.shadowWidth_; ++i) {
            for (j = 0; j < this.shadowHeight_; ++j) {
                this.simpleShadow_.setRGB(i, j, TRANSPARENT_RGB);
            }
        }
        for (i = 0; i <= this.shadowWidth_; ++i) {
            this.cosDTheta_[i] = 9999.0;
            for (j = 0; j <= this.shadowHeight_; ++j) {
                this.cosC_[j][i] = 9999.0;
            }
        }
        for (int j2 = 0; j2 <= this.shadowHeight_; j2 += this.darkSkip_) {
            int jx = Math.min(this.shadowHeight_, j2 + this.darkSkip_);
            for (int i2 = 0; i2 < this.shadowWidth_; i2 += this.darkSkip_) {
                int ix = Math.min(this.shadowWidth_, i2 + this.darkSkip_);
                this.drawDarkness(shadowG2D, i2, ix, j2, jx);
            }
        }
        shadowG2D.dispose();
        Graphics2D dstG2D = (Graphics2D)this.targetImage_.getGraphics();
        if (this.sourceImage_ == null) {
            dstG2D.setColor(new Color(255, 250, 250));
            dstG2D.fillRect(0, 0, this.outWidth_, this.outHeight_);
        } else {
            dstG2D.drawImage(this.sourceImage_, 0, 0, this.outWidth_, this.outHeight_, 0, 0, this.srcWidth_, this.srcHeight_, this);
        }
        dstG2D.drawImage(this.simpleShadow_, 0, 0, this.outWidth_, this.outHeight_, 0, 0, this.shadowWidth_, this.shadowHeight_, this);
        dstG2D.dispose();
        this.redrawNeeded_ = false;
    }

    private void drawDarkness(Graphics2D g2d, int left, int right, int top, int bottom) {
        if (left < 0 || bottom < 0) {
            return;
        }
        if (right > this.shadowWidth_ || bottom > this.shadowHeight_) {
            return;
        }
        int width = right - left;
        int height = bottom - top;
        if (width < 1 || height < 1) {
            return;
        }
        boolean isDark = true;
        double minCos = 1.0;
        for (int k = 0; k < 4; ++k) {
            int jx;
            int ix;
            if (k == 0) {
                ix = left;
                jx = top;
            } else if (k == 1) {
                ix = right;
                jx = top;
            } else if (k == 2) {
                ix = left;
                jx = bottom;
            } else {
                ix = right;
                jx = bottom;
            }
            if (this.cosC_[jx][ix] == 9999.0) {
                if (this.cosDTheta_[ix] == 9999.0) {
                    this.cosDTheta_[ix] = Math.cos((this.subsolarLon_ - this.mapLon_[ix]) * (Math.PI / 180));
                }
                this.cosC_[jx][ix] = this.cosSubsolarColat_ * this.cosMapColat_[jx] + this.sinSubsolarColat_ * this.sinMapColat_[jx] * this.cosDTheta_[ix];
            }
            if (this.cosC_[jx][ix] > 0.0) {
                isDark = false;
            }
            minCos = Math.min(minCos, this.cosC_[jx][ix]);
        }
        if (isDark) {
            g2d.setColor(this.shade_);
            g2d.fillRect(left, top, width, height);
        } else if (!(minCos > 0.2)) {
            int opacity;
            if (minCos > 0.0 && width < 2 && height < 2) {
                opacity = (int)(this.maxOpaqueF_ * (1.0 - minCos / 0.2));
                if (opacity < 0) {
                    opacity = 0;
                } else if (opacity > this.maxOpaque_) {
                    opacity = this.maxOpaque_;
                }
                g2d.setColor(new Color(0, 0, 0, opacity));
                g2d.fillRect(left, top, width, height);
            } else if (width < 2 && height < 2) {
                opacity = (int)(this.maxOpaqueF_ * (1.0 - minCos / 0.2));
                if (opacity < 0) {
                    opacity = 0;
                } else if (opacity > this.maxOpaque_) {
                    opacity = this.maxOpaque_;
                }
                g2d.setColor(new Color(0, 0, 0, opacity));
                g2d.fillRect(left, top, width, height);
            } else if (width < height) {
                int yAve = (top + bottom) / 2;
                this.drawDarkness(g2d, left, right, top, yAve);
                this.drawDarkness(g2d, left, right, yAve, bottom);
            } else {
                int xAve = (left + right) / 2;
                this.drawDarkness(g2d, left, xAve, top, bottom);
                this.drawDarkness(g2d, xAve, right, top, bottom);
            }
        }
    }
}

