/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtilities {
    private static final boolean DEBUG = false;
    private static final String JPG_EXT = "jpg";
    private static final String JPEG_EXT = "jpeg";
    private static final String TIF_EXT = "tif";
    private static final String TIFF_EXT = "tiff";
    private static String[] readableImageExtensions_;

    private ImageUtilities() {
    }

    public static String[] getReadableImageFileExtensions() {
        if (readableImageExtensions_ != null) {
            return readableImageExtensions_;
        }
        String[] readerExts = ImageIO.getReaderFormatNames();
        Vector<String> formatExts = new Vector<String>(30);
        for (String ext : readerExts) {
            String lcExt = ext.toLowerCase();
            boolean already = false;
            for (String ext2 : formatExts) {
                if (!ext2.equals(lcExt)) continue;
                already = true;
                break;
            }
            if (already) continue;
            formatExts.add(lcExt);
        }
        boolean jpgPresent = false;
        boolean jpegPresent = false;
        boolean tifPresent = false;
        boolean tiffPresent = false;
        for (String ext : formatExts) {
            if (ext.equalsIgnoreCase(JPG_EXT)) {
                jpgPresent = true;
            } else if (ext.equalsIgnoreCase(JPEG_EXT)) {
                jpegPresent = true;
            }
            if (ext.equalsIgnoreCase(TIF_EXT)) {
                tifPresent = true;
                continue;
            }
            if (!ext.equalsIgnoreCase(TIFF_EXT)) continue;
            tiffPresent = true;
        }
        if (jpgPresent && !jpegPresent) {
            formatExts.add(JPEG_EXT);
        }
        if (jpegPresent && !jpgPresent) {
            formatExts.add(JPG_EXT);
        }
        if (tifPresent && !tiffPresent) {
            formatExts.add(TIFF_EXT);
        }
        if (tiffPresent && !tifPresent) {
            formatExts.add(TIF_EXT);
        }
        Collections.sort(formatExts);
        readableImageExtensions_ = formatExts.toArray(new String[0]);
        return readableImageExtensions_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageDimensions(File f) throws FileNotFoundException, IOException {
        FileImageInputStream in = new FileImageInputStream(f);
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    public static BufferedImage toBufferedImage(File f) throws FileNotFoundException, IOException {
        String lcname = f.getName().toLowerCase();
        BufferedImage bimg = null;
        if (lcname.endsWith(".jpg") || lcname.endsWith(".jpeg")) {
            ImageIcon ii = new ImageIcon(f.toURI().toURL());
            bimg = ImageUtilities.toBufferedImage(ii.getImage());
        } else {
            bimg = ImageIO.read(f);
        }
        if (bimg == null) {
            throw new IllegalArgumentException("There is apparently no ImageIO reader registered for that filetype.");
        }
        return bimg;
    }

    public static BufferedImage toBufferedImage(Icon icon) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage bimage = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)bimage.getGraphics();
        if (icon instanceof ImageIcon) {
            g2d.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        } else {
            icon.paintIcon(null, g2d, 0, 0);
        }
        g2d.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtilities.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = hasAlpha ? 2 : 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException ignore) {
            // empty catch block
        }
        if (bimage == null) {
            int type = hasAlpha ? 2 : 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static int[] getARGBPixels(BufferedImage img) {
        int biType = img.getType();
        WritableRaster raster = img.getRaster();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pixels = new int[w * h];
        switch (biType) {
            case 1: {
                raster.getDataElements(0, 0, w, h, pixels);
                if (biType != 1) break;
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
            case 2: {
                raster.getDataElements(0, 0, w, h, pixels);
                break;
            }
            case 3: {
                raster.getDataElements(0, 0, w, h, pixels);
                if (biType != 1) break;
                int i = 0;
                while (i < pixels.length) {
                    int n = i++;
                    pixels[n] = pixels[n] | 0xFF000000;
                }
                break;
            }
            case 5: {
                byte[] scratch = new byte[3 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -16777216 + (scratch[i * 3 + 2] & 0xFF) + ((scratch[i * 3 + 1] & 0xFF) << 8) + ((scratch[i * 3 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 6: {
                byte[] scratch = new byte[4 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = ((scratch[i * 4 + 3] & 0xFF) << 24) + (scratch[i * 4 + 2] & 0xFF) + ((scratch[i * 4 + 1] & 0xFF) << 8) + ((scratch[i * 4 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 7: {
                byte[] scratch = new byte[4 * w * h];
                raster.getDataElements(0, 0, w, h, scratch);
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -16777216 + (scratch[i * 4 + 2] & 0xFF) + ((scratch[i * 4 + 1] & 0xFF) << 8) + ((scratch[i * 4 + 0] & 0xFF) << 16);
                }
                break;
            }
            case 12: 
            case 13: {
                IndexColorModel icm = (IndexColorModel)img.getColorModel();
                int transIdx = icm.getTransparentPixel();
                byte[] rowPixels = new byte[w];
                for (int row = 0; row < h; ++row) {
                    raster.getDataElements(0, row, w, 1, rowPixels);
                    for (int col = 0; col < w; ++col) {
                        int idx = rowPixels[col] & 0xFF;
                        pixels[row * w + col] = idx == transIdx ? 0 : 0xFF000000 | icm.getRGB(idx);
                    }
                }
                break;
            }
            default: {
                try {
                    PixelGrabber grabber = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
                    grabber.grabPixels();
                    break;
                }
                catch (Exception exc) {
                    System.err.println("Couldn't get pixels from PixelGrabber");
                    System.err.println("Returning unfilled array!");
                    exc.printStackTrace();
                }
            }
        }
        return pixels;
    }
}

