/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import com.jhlabs.image.QuantizeFilter;
import gov.nasa.giss.img.GifEncoder;
import gov.nasa.giss.img.ImageUtilities;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class GifWriter {
    private BufferedImage image_;

    public GifWriter() {
    }

    public GifWriter(BufferedImage img) {
        this.setImage(img);
    }

    public void flush() {
        this.image_ = null;
    }

    public void setImage(BufferedImage img) {
        this.image_ = img;
    }

    public void write(File f) throws IOException {
        this.write(new FileOutputStream(f));
    }

    public void write(FileOutputStream ostream) throws IOException {
        if (this.image_ == null) {
            throw new RuntimeException("Image has not been specified.");
        }
        try {
            new GifEncoder(this.image_).write(ostream);
            ostream.close();
            return;
        }
        catch (Exception ignore) {
            try {
                int iw = this.image_.getWidth();
                int ih = this.image_.getHeight();
                int[] srcPixels = ImageUtilities.getARGBPixels(this.image_);
                int[] dstPixels = new int[iw * ih];
                new QuantizeFilter().quantize(srcPixels, dstPixels, iw, ih, 256, false, true);
                new GifEncoder(dstPixels, iw, ih).write(ostream);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new RuntimeException("ERROR: Unable to save image as GIF. See console stack trace.");
            }
            ostream.close();
            return;
        }
    }
}

