/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.windoid;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class WindoidSectionHeader
extends JComponent {
    private static ImageIcon leftOpenIcon_;
    private static ImageIcon leftClosedIcon_;
    private static ImageIcon centerIcon_;
    private static ImageIcon rightIcon_;
    private static Image leftOpenImage_;
    private static Image leftClosedImage_;
    private static Image centerImage_;
    private static Image rightImage_;
    private static int hedHeight_;
    private static int hedWidthLeft_;
    private static int hedWidthRight_;
    private String title_;
    private int titleWidth_;
    private int lineHeight_;
    private int lineAscent_;
    private boolean measured_;
    private boolean expanded_ = true;

    public WindoidSectionHeader(String title) {
        this(title, true);
    }

    public WindoidSectionHeader(String title, boolean expanded) {
        Font f;
        this.title_ = title;
        if (leftOpenImage_ == null) {
            try {
                leftOpenIcon_ = new ImageIcon(this.getClass().getResource("sec_leftopen.png"));
                leftClosedIcon_ = new ImageIcon(this.getClass().getResource("sec_leftclosed.png"));
                centerIcon_ = new ImageIcon(this.getClass().getResource("sec_center.png"));
                rightIcon_ = new ImageIcon(this.getClass().getResource("sec_right.png"));
                hedHeight_ = leftOpenIcon_.getIconHeight();
                hedWidthLeft_ = leftOpenIcon_.getIconWidth();
                hedWidthRight_ = rightIcon_.getIconWidth();
                leftOpenImage_ = leftOpenIcon_.getImage();
                leftClosedImage_ = leftClosedIcon_.getImage();
                centerImage_ = centerIcon_.getImage();
                rightImage_ = rightIcon_.getImage();
            }
            catch (Exception exc) {
                leftOpenImage_ = null;
                leftClosedImage_ = null;
                centerImage_ = null;
                rightImage_ = null;
                this.setMinimumSize(new Dimension(12, 1));
                this.setPreferredSize(new Dimension(200, 1));
                this.setMaximumSize(new Dimension(4000, 1));
            }
        }
        if ((f = UIManager.getDefaults().getFont("Label.font")) != null) {
            f = f.deriveFont((float)((double)hedHeight_ * 2.0 / 3.0));
            this.setFont(f);
        }
        this.setOpaque(false);
        this.setExpanded(expanded);
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public void setExpanded(boolean expanded) {
        if (expanded == this.expanded_) {
            return;
        }
        this.expanded_ = expanded;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        int lwidth = Math.max(this.titleWidth_, hedWidthRight_);
        int hwidth = 2 * (hedWidthLeft_ + 2) + lwidth;
        return new Dimension(hwidth, hedHeight_ + 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    public void paintComponent(Graphics g) {
        if (!this.measured_) {
            this.measure();
        }
        super.paintComponent(g);
        if (leftOpenImage_ != null) {
            int w = this.getWidth();
            g.drawImage(centerImage_, 0, 0, w, hedHeight_, this);
            g.drawImage(rightImage_, w - hedWidthRight_, 0, hedWidthRight_, hedHeight_, this);
            if (this.expanded_) {
                g.drawImage(leftOpenImage_, 0, 0, this);
            } else {
                g.drawImage(leftClosedImage_, 0, 0, this);
            }
        }
        if (this.titleWidth_ > 0) {
            int x = hedWidthLeft_ + 2;
            int y = (hedHeight_ - this.lineHeight_) / 2 + this.lineAscent_;
            g.drawString(this.title_, x, y);
        }
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
        this.measured_ = true;
    }
}

