/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.windoid;

import gov.nasa.giss.gui.windoid.WindoidHeader;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class WindoidHeaderMouseAdapter
extends MouseInputAdapter {
    protected WindoidHeader header_;
    private boolean dragInProgress_;
    private Point windowPoint_;
    private Point mousePoint_;

    public WindoidHeaderMouseAdapter(WindoidHeader header) {
        this.header_ = header;
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.header_.isCloseable() && this.header_.inCloseButton(e.getPoint())) {
            ((Window)this.header_.getTopLevelAncestor()).setVisible(false);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.moveWindow(e.getPoint());
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(this.header_.isCloseable());
            this.header_.setResizeHighlighted(this.header_.isResizeable());
            this.header_.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(false);
            this.header_.setResizeHighlighted(false);
            this.header_.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.dragInProgress_ = true;
        Container parent = this.header_.getTopLevelAncestor();
        if (parent != null) {
            this.windowPoint_ = parent.getLocation();
            this.mousePoint_ = e.getPoint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.moveWindow(e.getPoint());
        this.dragInProgress_ = false;
    }

    private void moveWindow(Point p) {
        if (!this.dragInProgress_) {
            return;
        }
        int dx = p.x - this.mousePoint_.x;
        int dy = p.y - this.mousePoint_.y;
        this.windowPoint_.translate(dx, dy);
        Container parent = this.header_.getTopLevelAncestor();
        parent.setLocation(this.windowPoint_);
    }
}

