/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.windoid;

import gov.nasa.giss.gui.windoid.WindoidHeader;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JWindow;

public class Windoid
extends JWindow {
    private static final int MINI_GAP = 2;
    private WindoidHeader header_;
    private JComponent content_;

    public Windoid(String title, JFrame frame) {
        super(frame);
        this.header_ = new WindoidHeader(title, false);
        this.header_.addStandardMouseAdapter();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.header_);
        this.getContentPane().add(Box.createVerticalStrut(2));
        this.setFocusableWindowState(false);
    }

    public void addContent(JComponent jc) {
        if (this.content_ != null) {
            this.getContentPane().remove(this.content_);
        }
        this.content_ = jc;
        if (this.content_ != null) {
            this.getContentPane().add(this.content_);
        }
    }

    public JComponent getContent() {
        return this.content_;
    }

    public boolean getFocusableWindowState() {
        return true;
    }

    public void invalidate() {
        this.setSize(this.getPreferredSize());
        super.invalidate();
        this.validate();
        this.repaint();
    }

    public void validate() {
        super.validate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.content_ == null) {
            return this.header_.getPreferredSize();
        }
        Dimension d1 = this.header_.getPreferredSize();
        Dimension d2 = this.content_.getPreferredSize();
        return new Dimension(Math.max(d1.width, d2.width), d1.height + 2 + d2.height);
    }
}

