/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.treetable;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.gui.treetable.TreeTable;
import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class TreeTableCellRenderer
extends DefaultTableCellRenderer {
    protected static final Color GRAY = new Color(152, 152, 152);
    protected static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    protected static final int TRI_SIZE = 18;
    protected TreeTable ttable_;
    protected TreeTableNode node_;
    protected boolean hasFocus_;
    protected boolean selected_;
    protected Icon closedIcon_;
    protected Icon leafIcon_;
    protected Icon openIcon_;
    protected static Path2D.Float collapsedTriangle_;
    protected static Path2D.Float expandedTriangle_;
    protected int gap_;
    protected int halfGap_;
    protected int iconWidth_;
    protected int leftShift_;

    public TreeTableCellRenderer() {
        this.setHorizontalAlignment(2);
        this.leafIcon_ = UIManager.getIcon("Tree.leafIcon");
        this.closedIcon_ = UIManager.getIcon("Tree.closedIcon");
        this.openIcon_ = UIManager.getIcon("Tree.openIcon");
        this.calculateIconWidth();
        this.gap_ = this.getIconTextGap();
        this.halfGap_ = this.gap_ / 2;
        float margin = 2.0f;
        if (collapsedTriangle_ == null) {
            collapsedTriangle_ = new Path2D.Float();
            collapsedTriangle_.moveTo(4.0f, 3.0f);
            collapsedTriangle_.lineTo(12.75f, 7.5f);
            collapsedTriangle_.lineTo(4.0f, 12.0f);
            collapsedTriangle_.closePath();
        }
        if (expandedTriangle_ == null) {
            expandedTriangle_ = new Path2D.Float();
            expandedTriangle_.moveTo(3.0f, 4.0f);
            expandedTriangle_.lineTo(12.0f, 4.0f);
            expandedTriangle_.lineTo(7.5f, 11.75f);
            expandedTriangle_.closePath();
        }
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        int textX = this.getTextX(this.ttable_, this.node_, null);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textLen = fm.stringWidth(this.getText());
        int h = super.getPreferredSize().height;
        return new Dimension(ins.left + textX + textLen + ins.right, h);
    }

    public Icon getOpenIcon() {
        return this.openIcon_;
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon_ = newIcon;
        this.calculateIconWidth();
    }

    public Icon getClosedIcon() {
        return this.closedIcon_;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon_ = newIcon;
        this.calculateIconWidth();
    }

    public Icon getLeafIcon() {
        return this.leafIcon_;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon_ = newIcon;
        this.calculateIconWidth();
    }

    private void calculateIconWidth() {
        int w1 = this.leafIcon_ != null ? this.leafIcon_.getIconWidth() : 0;
        int w2 = this.closedIcon_ != null ? this.leafIcon_.getIconWidth() : 0;
        int w3 = this.openIcon_ != null ? this.leafIcon_.getIconWidth() : 0;
        this.iconWidth_ = Math.max(Math.max(w1, w2), w3);
    }

    public void setLeftShift(int shift) {
        this.leftShift_ = shift;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
        this.ttable_ = (TreeTable)table;
        TreeTableModel tmodel = this.ttable_.getTreeTableModel();
        this.node_ = tmodel.getNodeForRow(row);
        String stringValue = this.node_.getName();
        this.setText(stringValue);
        if (this.node_.isLeaf() && !this.node_.getAllowsChildren()) {
            this.setIcon(this.leafIcon_);
        } else if (this.ttable_.isExpanded(row)) {
            this.setIcon(this.openIcon_);
        } else {
            this.setIcon(this.closedIcon_);
        }
        this.selected_ = selected;
        this.hasFocus_ = this.ttable_.hasFocus();
        this.setLeftShift(0);
        return this;
    }

    public void paint(Graphics g) {
        Color bgColor = this.getBackground();
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.setBackground(TRANSPARENT);
        super.paint(g);
    }

    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        if (icon == null) {
            super.paint(g);
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate((double)(-this.leftShift_), 0.0);
        Insets ins = this.getInsets();
        int uwidth = this.getWidth() - ins.left - ins.right;
        int uheight = this.getHeight() - ins.top - ins.bottom;
        if (icon != this.leafIcon_) {
            int triX = this.getDisclosureX(this.ttable_, this.node_, icon);
            int triY = (uheight - 18) / 2;
            GraphicUtilities.antialias(g2d);
            if (this.selected_ && this.hasFocus_) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(GRAY);
            }
            g2d.translate(ins.left + triX, ins.top + triY);
            if (icon == this.openIcon_) {
                g2d.fill(expandedTriangle_);
            } else if (icon == this.closedIcon_) {
                g2d.fill(collapsedTriangle_);
            }
            g2d.translate(-(ins.left + triX), -(ins.top + triY));
        }
        int iconX = this.getIconX(this.ttable_, this.node_, icon);
        int iconY = (uheight - icon.getIconHeight()) / 2;
        int textX = this.getTextX(this.ttable_, this.node_, icon);
        icon.paintIcon(this, g2d, ins.left + iconX, ins.top + iconY);
        Border inner = BorderFactory.createEmptyBorder(0, textX, 0, 0);
        this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), inner));
        this.setIcon(null);
        super.setBackground(TRANSPARENT);
        super.paintComponent(g2d);
        g2d.dispose();
    }

    public int getDisclosureX(TreeTable ttable, TreeTableNode node, Icon icon) {
        TreeTableModel tmodel = ttable.getTreeTableModel();
        int depth = node.getPath().length - 1;
        if (!ttable.isRootVisible()) {
            --depth;
        }
        if (depth == 0) {
            return 0;
        }
        return 18 + this.halfGap_ + (depth - 1) * (this.iconWidth_ + this.gap_);
    }

    public int getIconX(TreeTable ttable, TreeTableNode node, Icon icon) {
        return this.getDisclosureX(ttable, node, icon) + (18 + this.halfGap_);
    }

    public int getTextX(TreeTable ttable, TreeTableNode node, Icon icon) {
        return this.getIconX(ttable, node, icon) + (this.iconWidth_ + this.gap_);
    }
}

