/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.treetable;

import gov.nasa.giss.gui.treetable.TreeTable;
import gov.nasa.giss.gui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.gui.treetable.TreeTableTextField;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private TreeTable ttable_;
    private TreeTableCellRenderer renderer_;

    public TreeTableCellEditor(TreeTable ttable, TreeTableCellRenderer renderer) {
        super(new TreeTableTextField());
        this.ttable_ = ttable;
        this.renderer_ = renderer;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, col);
        TreeTableModel tmodel = this.ttable_.getTreeTableModel();
        TreeTableNode node = tmodel.getNodeForRow(row);
        int textX = this.renderer_.getTextX(this.ttable_, node, null);
        ((TreeTableTextField)this.getComponent()).setOffset(textX);
        return component;
    }

    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (!(e instanceof MouseEvent)) {
            return false;
        }
        MouseEvent me = (MouseEvent)e;
        if ((me.getModifiers() & 0x10) == 0) {
            return false;
        }
        TreeTableModel tmodel = this.ttable_.getTreeTableModel();
        TreeTableNode node = this.ttable_.getNodeForPoint(me.getPoint());
        if (node == null) {
            return false;
        }
        int x = me.getX();
        int isize = this.ttable_.getColumnCount();
        TreeTableModel model = this.ttable_.getTreeTableModel();
        for (int col = 0; col < isize; ++col) {
            if (this.ttable_.getColumnClass(col) != TreeTableModel.class) continue;
            int discloseX = this.renderer_.getDisclosureX(this.ttable_, node, null);
            int iconX = this.renderer_.getIconX(this.ttable_, node, null);
            int textX = this.renderer_.getTextX(this.ttable_, node, null);
            if (me.getModifiers() == 16) {
                if (!node.getAllowsChildren()) break;
                if (x < discloseX) continue;
                if (x >= iconX && me.getClickCount() <= 1) break;
                model.toggleNode(node);
                this.ttable_.repaint();
                break;
            }
            if (me.getModifiers() != 24 || !node.isEditable() || x <= iconX) break;
            return true;
        }
        return false;
    }
}

