/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.treetable;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.treetable.TreeTable;
import gov.nasa.giss.gui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;

public class SourceListTreeTableCellRenderer
extends TreeTableCellRenderer {
    protected static final Color FOCUSED_BACKGROUND = new Color(218, 223, 230);
    protected static final Color UNFOCUSED_BACKGROUND = new Color(237, 237, 237);

    public SourceListTreeTableCellRenderer() {
        this.iconWidth_ = 0;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
        this.ttable_ = (TreeTable)table;
        TreeTableModel tmodel = this.ttable_.getTreeTableModel();
        this.node_ = tmodel.getNodeForRow(row);
        String stringValue = this.node_.getName();
        this.setText(stringValue);
        if (!this.node_.getAllowsChildren()) {
            this.setIcon(this.leafIcon_);
        } else {
            this.setIcon(null);
        }
        this.selected_ = selected;
        this.hasFocus_ = GuiUtilities.isParentWindowFocused(this.ttable_);
        this.setLeftShift(0);
        return this;
    }

    public void paint(Graphics g) {
        if (this.hasFocus_) {
            g.setColor(FOCUSED_BACKGROUND);
        } else {
            g.setColor(UNFOCUSED_BACKGROUND);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.setBackground(TRANSPARENT);
        super.paint(g);
    }

    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        if (icon == null) {
            super.paint(g);
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate((double)(-this.leftShift_), 0.0);
        Insets ins = this.getInsets();
        int uwidth = this.getWidth() - ins.left - ins.right;
        int uheight = this.getHeight() - ins.top - ins.bottom;
        if (icon != this.leafIcon_) {
            int triX = this.getDisclosureX(this.ttable_, this.node_, icon);
            int triY = (uheight - 18) / 2;
            GraphicUtilities.antialias(g2d);
            if (this.selected_ && this.hasFocus_) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(GRAY);
            }
            g2d.translate(ins.left + triX, ins.top + triY);
            if (icon == this.openIcon_) {
                g2d.fill(expandedTriangle_);
            } else if (icon == this.closedIcon_) {
                g2d.fill(collapsedTriangle_);
            }
            g2d.translate(-(ins.left + triX), -(ins.top + triY));
        }
        int iconX = this.getIconX(this.ttable_, this.node_, icon);
        int iconY = (uheight - icon.getIconHeight()) / 2;
        int textX = this.getTextX(this.ttable_, this.node_, icon);
        icon.paintIcon(this, g2d, ins.left + iconX, ins.top + iconY);
        Border inner = BorderFactory.createEmptyBorder(0, textX, 0, 0);
        this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), inner));
        this.setIcon(null);
        super.setBackground(TRANSPARENT);
        super.paintComponent(g2d);
        g2d.dispose();
    }

    public int getDisclosureX(TreeTable ttable, TreeTableNode node, Icon icon) {
        TreeTableModel tmodel = ttable.getTreeTableModel();
        int depth = node.getPath().length - 1;
        if (!ttable.isRootVisible()) {
            --depth;
        }
        if (depth == 0) {
            return 0;
        }
        return 18 + this.halfGap_ + (depth - 1) * (this.iconWidth_ + this.gap_);
    }

    public int getIconX(TreeTable ttable, TreeTableNode node, Icon icon) {
        return this.getDisclosureX(ttable, node, icon) + (18 + this.halfGap_);
    }

    public int getTextX(TreeTable ttable, TreeTableNode node, Icon icon) {
        return this.getIconX(ttable, node, icon) + (this.iconWidth_ + this.gap_);
    }
}

