/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.task;

import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.gui.task.TaskListener;
import gov.nasa.giss.gui.task.TaskQueueEvent;
import gov.nasa.giss.gui.task.TaskQueueListener;
import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class TaskQueue
implements TaskListener {
    private ArrayList<Task> tasklist_;
    private EventListenerList listenerList_ = new EventListenerList();
    private Task currentTask_;

    public TaskQueue() {
        this.tasklist_ = new ArrayList();
    }

    public int size() {
        return this.tasklist_.size();
    }

    public Task getCurrentTask() {
        if (this.size() == 0) {
            return null;
        }
        return this.currentTask_;
    }

    public void add(Task task) {
        task.addTaskListener(this);
        this.tasklist_.add(task);
        if (this.size() == 1) {
            this.startNextTask();
        }
    }

    public boolean remove(Task task) {
        if (task == this.currentTask_) {
            return false;
        }
        if (!this.tasklist_.contains(task)) {
            return false;
        }
        this.tasklist_.remove(task);
        task.removeTaskListener(this);
        return true;
    }

    private boolean startNextTask() {
        Task task;
        if (this.currentTask_ != null) {
            return false;
        }
        if (this.size() < 1) {
            return false;
        }
        this.currentTask_ = task = this.tasklist_.get(0);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                task.execute();
            }
        });
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 0);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskStarted(tqe);
        }
        return true;
    }

    public synchronized void addQueueListener(TaskQueueListener l) {
        this.listenerList_.add(TaskQueueListener.class, l);
    }

    public synchronized void removeQueueListener(TaskQueueListener l) {
        this.listenerList_.remove(TaskQueueListener.class, l);
    }

    public synchronized void removeQueueListeners() {
        TaskQueueListener[] ll = (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class);
        for (int i = ll.length - 1; i >= 0; --i) {
            this.removeQueueListener(ll[i]);
        }
    }

    public void taskCommenced(Task task) {
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 0);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskStarted(tqe);
        }
    }

    public void taskCompleted(Task task) {
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 0);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskCompleted(tqe);
        }
        if (task == this.currentTask_) {
            this.currentTask_ = null;
            this.taskFinished(task);
        } else {
            this.remove(task);
        }
    }

    public void taskCanceled(Task task) {
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 0);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskCanceled(tqe);
        }
        if (task == this.currentTask_) {
            this.currentTask_ = null;
            this.taskFinished(task);
        } else {
            this.remove(task);
        }
    }

    private void taskFinished(Task task) {
        if (task == null) {
            System.out.println("WARNING: Null task");
            return;
        }
        this.remove(task);
        if (this.size() > 0) {
            this.startNextTask();
        } else {
            TaskQueueEvent tqe = new TaskQueueEvent(this, null, 0);
            for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
                tql.queueEmptied(tqe);
            }
        }
    }
}

