/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.task;

import gov.nasa.giss.gui.task.TaskListener;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;

public abstract class Task
extends SwingWorker {
    private EventListenerList listenerList_ = new EventListenerList();
    private String description_;

    public Task() {
        this("");
    }

    public Task(String description) {
        this.description_ = description;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean isBusy() {
        SwingWorker.StateValue state = this.getState();
        return state == SwingWorker.StateValue.PENDING || state == SwingWorker.StateValue.STARTED;
    }

    public final Object doInBackground() {
        if (this.isCancelled()) {
            return null;
        }
        return this.beginTask();
    }

    protected abstract Object beginTask();

    public final void done() {
        if (!this.isCancelled()) {
            this.finishTask();
        }
        for (TaskListener tl : (TaskListener[])this.listenerList_.getListeners(TaskListener.class)) {
            if (this.isCancelled()) {
                tl.taskCanceled(this);
                continue;
            }
            tl.taskCompleted(this);
        }
        this.removeTaskListeners();
        super.done();
    }

    protected abstract void finishTask();

    public synchronized void addTaskListener(TaskListener l) {
        this.listenerList_.add(TaskListener.class, l);
    }

    public synchronized void removeTaskListener(TaskListener l) {
        this.listenerList_.remove(TaskListener.class, l);
    }

    public synchronized void removeTaskListeners() {
        TaskListener[] ll = (TaskListener[])this.listenerList_.getListeners(TaskListener.class);
        for (int i = ll.length - 1; i >= 0; --i) {
            this.removeTaskListener(ll[i]);
        }
    }
}

