/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.table;

import java.awt.Color;

public class TableTheme {
    private static final Color PALE_BLUE = new Color(237, 243, 254);
    private static final Color PALE_GREEN = new Color(221, 255, 221);
    private static final Color PALE_RED = new Color(255, 221, 221);
    private static final Color PALE_YELLOW = new Color(255, 255, 221);
    private static final Color GRAY_217 = new Color(217, 217, 217);
    private static final Color GRAY_221 = new Color(221, 221, 221);
    private static final Color GRAY_229 = new Color(229, 229, 229);
    private static final Color GRAY_240 = new Color(240, 240, 240);
    public static final TableTheme APPLE = new TableTheme(true, false, GRAY_217, new Color[]{Color.WHITE, PALE_BLUE});
    public static final TableTheme APPLE_GRAPHITE = new TableTheme(true, false, GRAY_221, new Color[]{Color.WHITE, GRAY_240});
    public static final TableTheme FANFOLD = new TableTheme(false, false, null, new Color[]{Color.WHITE, PALE_GREEN});
    public static final TableTheme FANFOLD_A = new TableTheme(true, false, GRAY_229, new Color[]{Color.WHITE, PALE_GREEN});
    public static final TableTheme SPREADSHEET = new TableTheme(true, false, GRAY_229, new Color[]{PALE_YELLOW, PALE_GREEN});
    public static final TableTheme CANDY_STRIPE = new TableTheme(false, false, null, new Color[]{Color.WHITE, PALE_RED});
    public static final TableTheme HUD = new TableTheme(true, false, Color.GRAY, new Color[]{Color.BLACK, Color.DARK_GRAY}, Color.WHITE);
    private Color[] rowColors_;
    private Color gridColor_;
    private Color foreground_ = Color.BLACK;
    private boolean vlinesVisible_;
    private boolean hlinesVisible_;

    public TableTheme() {
    }

    public TableTheme(boolean vlinesVisible, boolean hlinesVisible, Color gridColor, Color[] rowColors, Color foreground) {
        this.vlinesVisible_ = vlinesVisible;
        this.hlinesVisible_ = hlinesVisible;
        this.gridColor_ = gridColor;
        this.rowColors_ = rowColors;
        this.foreground_ = foreground;
    }

    public TableTheme(boolean vlinesVisible, boolean hlinesVisible, Color gridColor, Color[] rowColors) {
        this(vlinesVisible, hlinesVisible, gridColor, rowColors, Color.BLACK);
    }

    public TableTheme clone() {
        TableTheme result = new TableTheme(this.vlinesVisible_, this.hlinesVisible_, this.cloneColor(this.gridColor_), this.cloneColors(this.rowColors_));
        return result;
    }

    private Color[] cloneColors(Color[] colors) {
        if (colors == null) {
            return null;
        }
        Color[] cnew = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            cnew[i] = this.cloneColor(colors[i]);
        }
        return cnew;
    }

    private Color cloneColor(Color color) {
        Color cnew = new Color(color.getRGB());
        return cnew;
    }

    public Color getForeground() {
        return this.foreground_;
    }

    public Color getBackground(int row) {
        if (this.rowColors_ == null) {
            return Color.WHITE;
        }
        int index = row % this.rowColors_.length;
        return this.cloneColor(this.rowColors_[index]);
    }

    public Color[] getRowColors() {
        if (this.rowColors_ == null) {
            return new Color[]{Color.WHITE};
        }
        return this.cloneColors(this.rowColors_);
    }

    public Color getGridColor() {
        return this.cloneColor(this.gridColor_);
    }

    public boolean getShowGrid() {
        return this.vlinesVisible_ || this.hlinesVisible_;
    }

    public boolean getShowVerticalLines() {
        return this.vlinesVisible_;
    }

    public boolean getShowHorizontalLines() {
        return this.hlinesVisible_;
    }
}

