/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.table;

import gov.nasa.giss.gui.table.ColumnHeaderRenderer;
import gov.nasa.giss.gui.table.GissTable;
import gov.nasa.giss.gui.table.RowHeaderRenderer;
import gov.nasa.giss.gui.table.TableRowHeader;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TableMouseListener
extends MouseInputAdapter {
    private GissTable table_;
    private boolean performingPopupTrigger_;
    private int pressIndex_ = -1;

    public TableMouseListener(GissTable table) {
        this.table_ = table;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseClicked(MouseEvent e) {
        if (this.performingPopupTrigger_) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof JTableHeader) {
            int col0;
            if (!this.table_.getColumnSelectionAllowed()) {
                return;
            }
            this.table_.clearRowHeaders();
            TableColumnModel tcm = this.table_.getColumnModel();
            int col1 = col0 = tcm.getColumnIndexAtX(e.getX());
            TableCellRenderer r = this.table_.getColumnHeaderRenderer(col1);
            if (e.isShiftDown() && r instanceof ColumnHeaderRenderer && (col0 = ((ColumnHeaderRenderer)r).getSelectedColumns()[0]) == -1) {
                col0 = col1;
            }
            if (r instanceof ColumnHeaderRenderer) {
                ((ColumnHeaderRenderer)r).setSelectedColumns(col0, col1);
            }
            this.table_.selectColumns(col0, col1);
            if (e.getClickCount() <= 1) {
                // empty if block
            }
        } else if (source instanceof TableRowHeader) {
            if (!this.table_.getRowSelectionAllowed()) {
                return;
            }
            this.table_.clearColumnHeaders();
            TableRowHeader rowHeader = this.table_.getTableRowHeader();
            if (this.table_.getColumnCount() == 0) {
                return;
            }
            ListSelectionModel lsm = rowHeader.getSelectionModel();
            int row0 = lsm.getAnchorSelectionIndex();
            int row1 = lsm.getLeadSelectionIndex();
            TableCellRenderer r = this.table_.getRowHeaderRenderer(row0);
            if (e.isShiftDown() && r instanceof RowHeaderRenderer && (row0 = ((RowHeaderRenderer)r).getSelectedRows()[0]) == -1) {
                row0 = row1;
            }
            if (r instanceof RowHeaderRenderer) {
                ((RowHeaderRenderer)r).setSelectedRows(row0, row1);
            }
            this.table_.selectRows(row0, row1);
        } else if (source instanceof JTable) {
            this.table_.clearRowHeaders();
            this.table_.clearColumnHeaders();
        }
        this.table_.repaintHeaders();
    }

    public void mousePressed(MouseEvent e) {
        this.performingPopupTrigger_ = e.isPopupTrigger();
        if (this.performingPopupTrigger_) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof JTableHeader) {
            int col0;
            if (!this.table_.getColumnSelectionAllowed()) {
                return;
            }
            this.table_.clearRowHeaders();
            TableColumnModel tcm = this.table_.getColumnModel();
            int col1 = col0 = tcm.getColumnIndexAtX(e.getX());
            TableCellRenderer r = this.table_.getColumnHeaderRenderer(col1);
            if (e.isShiftDown() && r instanceof ColumnHeaderRenderer && (col0 = ((ColumnHeaderRenderer)r).getSelectedColumns()[0]) == -1) {
                col0 = col1;
            }
            this.table_.selectColumns(col0, col1);
            if (r instanceof ColumnHeaderRenderer) {
                ((ColumnHeaderRenderer)r).setPressedColumns(col0, col1);
            }
            this.pressIndex_ = col0;
        } else if (source instanceof TableRowHeader) {
            if (!this.table_.getRowSelectionAllowed()) {
                return;
            }
            this.table_.clearColumnHeaders();
            TableRowHeader rowHeader = this.table_.getTableRowHeader();
            ListSelectionModel lsm = rowHeader.getSelectionModel();
            int row0 = lsm.getAnchorSelectionIndex();
            int row1 = lsm.getLeadSelectionIndex();
            TableCellRenderer r = this.table_.getRowHeaderRenderer(row1);
            if (e.isShiftDown()) {
                if (r instanceof RowHeaderRenderer && (row0 = ((RowHeaderRenderer)r).getSelectedRows()[0]) == -1) {
                    row0 = row1;
                }
                if (row0 > -1) {
                    lsm.setAnchorSelectionIndex(row0);
                }
            }
            this.table_.selectRows(row0, row1);
            if (r instanceof RowHeaderRenderer) {
                ((RowHeaderRenderer)r).setPressedRows(row0, row1);
            }
        } else if (source instanceof JTable) {
            this.table_.clearRowHeaders();
            this.table_.clearColumnHeaders();
        }
        this.table_.repaintHeaders();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.performingPopupTrigger_) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof JTableHeader) {
            if (!this.table_.getColumnSelectionAllowed()) {
                return;
            }
            TableColumnModel tcm = this.table_.getColumnModel();
            int col1 = tcm.getColumnIndexAtX(e.getX());
            int col0 = this.pressIndex_;
            if (col1 == -1) {
                col1 = e.getX() < 0 ? 0 : this.table_.getColumnCount() - 1;
            }
            TableCellRenderer r = this.table_.getColumnHeaderRenderer(col1);
            this.table_.selectColumns(this.pressIndex_, col1);
            if (r instanceof ColumnHeaderRenderer) {
                ((ColumnHeaderRenderer)r).setSelectedColumns(this.pressIndex_, col1);
            }
            this.pressIndex_ = -1;
        } else if (source instanceof TableRowHeader) {
            if (!this.table_.getRowSelectionAllowed()) {
                return;
            }
            TableRowHeader rowHeader = this.table_.getTableRowHeader();
            ListSelectionModel lsm = rowHeader.getSelectionModel();
            int row0 = lsm.getAnchorSelectionIndex();
            int row1 = lsm.getLeadSelectionIndex();
            this.table_.selectRows(row0, row1);
            TableCellRenderer r = this.table_.getRowHeaderRenderer(row0);
            if (r instanceof RowHeaderRenderer) {
                ((RowHeaderRenderer)r).setSelectedRows(row0, row1);
            }
        } else if (source instanceof JTable) {
            // empty if block
        }
        this.table_.repaintHeaders();
    }

    public void mouseDragged(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof JTableHeader) {
            if (!this.table_.getColumnSelectionAllowed()) {
                return;
            }
            TableColumnModel tcm = this.table_.getColumnModel();
            int col = tcm.getColumnIndexAtX(e.getX());
            if (col == -1) {
                col = e.getX() < 0 ? 0 : this.table_.getColumnCount() - 1;
            }
            this.table_.selectColumns(this.pressIndex_, col);
            TableCellRenderer r = this.table_.getColumnHeaderRenderer(col);
            if (r instanceof ColumnHeaderRenderer) {
                ((ColumnHeaderRenderer)r).setPressedColumns(this.pressIndex_, col);
            }
        } else if (source instanceof TableRowHeader) {
            if (!this.table_.getRowSelectionAllowed()) {
                return;
            }
            TableRowHeader rowHeader = this.table_.getTableRowHeader();
            ListSelectionModel lsm = rowHeader.getSelectionModel();
            int row0 = lsm.getAnchorSelectionIndex();
            int row1 = lsm.getLeadSelectionIndex();
            this.table_.selectRows(row0, row1);
            TableCellRenderer r = this.table_.getRowHeaderRenderer(row0);
            if (r instanceof RowHeaderRenderer) {
                ((RowHeaderRenderer)r).setPressedRows(row0, row1);
            }
        } else if (source instanceof JTable) {
            // empty if block
        }
        this.table_.repaintHeaders();
    }
}

