/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.table;

import com.explodingpixels.macwidgets.plaf.EmphasizedLabelUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public class RowHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private static final String UI_CLASS_ID = "EmphasizedLabelUI";
    private static final Color LEFT_UNSELECTED_BORDER_COLOR = new Color(217, 217, 217);
    private static final Color LEFT_PRESSED_UNSELECTED_BORDER_COLOR = new Color(192, 192, 192);
    private static final Color LEFT_SELECTED_BORDER_COLOR = new Color(171, 187, 206);
    private static final Color RIGHT_UNSELECTED_BORDER_COLOR = new Color(156, 156, 156);
    private static final Color RIGHT_SELECTED_BORDER_COLOR = new Color(138, 151, 166);
    private static final Color BOTTOM_BORDER_COLOR = new Color(85, 85, 85);
    private static final Color UNSELECTED_TOP_COLOR = new Color(219, 219, 219);
    private static final Color UNSELECTED_BOTTOM_COLOR = new Color(187, 187, 187);
    private static final Color SELECTED_TOP_COLOR = new Color(194, 207, 221);
    private static final Color SELECTED_BOTTOM_COLOR = new Color(125, 147, 178);
    private static final Color PRESSED_UNSELECTED_TOP_COLOR = new Color(196, 196, 196);
    private static final Color PRESSED_UNSELECTED_BOTTOM_COLOR = new Color(149, 149, 149);
    private static final Color PRESSED_SELECTED_TOP_COLOR = new Color(150, 183, 203);
    private static final Color PRESSED_SELECTED_BOTTOM_COLOR = new Color(83, 107, 144);
    private JTable table_;
    private int[] pressedRows_ = new int[]{-1, -1};
    private int[] selectedRows_ = new int[]{-1, -1};
    private Color topColor_ = UNSELECTED_TOP_COLOR;
    private Color bottomColor_ = UNSELECTED_BOTTOM_COLOR;

    public RowHeaderRenderer() {
        super("");
        this.setOpaque(false);
        this.setFont(UIManager.getFont("Table.font").deriveFont(1, 11.0f));
    }

    public RowHeaderRenderer(JTable table) {
        this();
        this.table_ = table;
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((EmphasizedLabelUI)UIManager.getUI(this));
        } else {
            this.setUI(EmphasizedLabelUI.createUI(this));
        }
    }

    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void clear() {
        this.pressedRows_[0] = -1;
        this.pressedRows_[1] = -1;
        this.selectedRows_[0] = -1;
        this.selectedRows_[1] = -1;
    }

    public void setPressedRows(int row0, int row1) {
        this.pressedRows_[0] = row0;
        this.pressedRows_[1] = row1;
        this.selectedRows_[0] = -1;
        this.selectedRows_[1] = -1;
    }

    public int[] getSelectedRows() {
        return this.selectedRows_;
    }

    public void setSelectedRows(int row0, int row1) {
        this.selectedRows_[0] = row0;
        this.selectedRows_[1] = row1;
        this.pressedRows_[0] = -1;
        this.pressedRows_[1] = -1;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setText(value.toString());
        Window window = SwingUtilities.getWindowAncestor(this.table_);
        if (window == null) {
            return this;
        }
        boolean windowHasFocus = window.isFocused();
        CompoundBorder leftSpacerBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getLeftBorderColor(row, windowHasFocus)), BorderFactory.createEmptyBorder(1, 4, 0, 4));
        CompoundBorder bottomRightBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BOTTOM_BORDER_COLOR), BorderFactory.createMatteBorder(0, 0, 0, 1, this.getRightBorderColor(row, windowHasFocus)));
        this.setBorder(BorderFactory.createCompoundBorder(bottomRightBorder, leftSpacerBorder));
        this.topColor_ = this.getTopColor(row, windowHasFocus);
        this.bottomColor_ = this.getBottomColor(row, windowHasFocus);
        return this;
    }

    private Color getTopColor(int row, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return UNSELECTED_TOP_COLOR;
        }
        if (this.isSelectedRow(row) && this.isPressedRow(row)) {
            return PRESSED_SELECTED_TOP_COLOR;
        }
        if (this.isSelectedRow(row)) {
            return SELECTED_TOP_COLOR;
        }
        if (this.isPressedRow(row)) {
            return PRESSED_UNSELECTED_TOP_COLOR;
        }
        return UNSELECTED_TOP_COLOR;
    }

    private Color getBottomColor(int row, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return UNSELECTED_BOTTOM_COLOR;
        }
        if (this.isSelectedRow(row) && this.isPressedRow(row)) {
            return PRESSED_SELECTED_BOTTOM_COLOR;
        }
        if (this.isSelectedRow(row)) {
            return SELECTED_BOTTOM_COLOR;
        }
        if (this.isPressedRow(row)) {
            return PRESSED_UNSELECTED_BOTTOM_COLOR;
        }
        return UNSELECTED_BOTTOM_COLOR;
    }

    private Color getLeftBorderColor(int row, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return LEFT_UNSELECTED_BORDER_COLOR;
        }
        if (this.isSelectedRow(row) && this.isPressedRow(row)) {
            return LEFT_SELECTED_BORDER_COLOR;
        }
        if (this.isSelectedRow(row)) {
            return LEFT_SELECTED_BORDER_COLOR;
        }
        if (this.isPressedRow(row)) {
            return LEFT_PRESSED_UNSELECTED_BORDER_COLOR;
        }
        return LEFT_UNSELECTED_BORDER_COLOR;
    }

    private Color getRightBorderColor(int row, boolean windowHasFocus) {
        return windowHasFocus && this.isSelectedRow(row) ? RIGHT_SELECTED_BORDER_COLOR : RIGHT_UNSELECTED_BORDER_COLOR;
    }

    private boolean isPressedRow(int row) {
        if (this.pressedRows_[0] == -1 || this.pressedRows_[1] == -1) {
            return false;
        }
        if (this.pressedRows_[1] < this.pressedRows_[0]) {
            return row >= this.pressedRows_[1] & row <= this.pressedRows_[0];
        }
        return row >= this.pressedRows_[0] & row <= this.pressedRows_[1];
    }

    private boolean isSelectedRow(int row) {
        if (this.selectedRows_[0] == -1 || this.selectedRows_[1] == -1) {
            return false;
        }
        if (this.selectedRows_[1] < this.selectedRows_[0]) {
            return row >= this.selectedRows_[1] & row <= this.selectedRows_[0];
        }
        return row >= this.selectedRows_[0] & row <= this.selectedRows_[1];
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.topColor_, 0.0f, this.getHeight(), this.bottomColor_);
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.dispose();
        super.paintComponent(g);
    }
}

