/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.table;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.table.ColumnHeaderRenderer;
import gov.nasa.giss.gui.table.GissTableCellBorder;
import gov.nasa.giss.gui.table.RowHeaderRenderer;
import gov.nasa.giss.gui.table.TableMouseListener;
import gov.nasa.giss.gui.table.TableRowHeader;
import gov.nasa.giss.gui.table.TableTheme;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GissTable
extends JTable {
    private static final TableTheme DEFAULT_THEME = TableTheme.APPLE;
    private static final Color UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR = new Color(192, 192, 192);
    private static final Color CORNER_BORDER_COLOR_LEFT = new Color(217, 217, 217);
    private static final Color CORNER_BORDER_COLOR_RIGHT = new Color(156, 156, 156);
    private static final Color CORNER_BORDER_COLOR_BOTTOM = new Color(85, 85, 85);
    private static final Color GRAPHITE_FOCUS_COLOR = new Color(94, 107, 121);
    private TableTheme theme_;
    private TableMouseListener mouseAdapter_;
    private TableRowHeader rowHeader_;

    public GissTable() {
        this.initMe(DEFAULT_THEME);
    }

    public GissTable(TableModel model) {
        this(model, DEFAULT_THEME);
    }

    public GissTable(TableModel model, TableTheme theme) {
        super(model);
        this.initMe(theme);
    }

    private void initMe(TableTheme theme) {
        this.setIntercellSpacing(new Dimension());
        ColumnHeaderRenderer thr = new ColumnHeaderRenderer(this);
        thr.setHorizontalAlignment(0);
        JTableHeader colHeader = this.getTableHeader();
        colHeader.setDefaultRenderer(thr);
        colHeader.setReorderingAllowed(false);
        this.mouseAdapter_ = new TableMouseListener(this);
        this.addMouseListener(this.mouseAdapter_);
        this.addMouseMotionListener(this.mouseAdapter_);
        colHeader.addMouseListener(this.mouseAdapter_);
        colHeader.addMouseMotionListener(this.mouseAdapter_);
        this.setTheme(theme);
        ActionMap map = this.getActionMap();
        Action a = TransferHandler.getCopyAction();
        map.put(a.getValue("Name"), a);
    }

    public TableRowHeader getTableRowHeader() {
        return this.rowHeader_;
    }

    public void setTableRowHeader(TableRowHeader header) {
        this.rowHeader_ = header;
        this.rowHeader_.addMouseListener(this.mouseAdapter_);
        this.rowHeader_.addMouseMotionListener(this.mouseAdapter_);
    }

    public TableTheme getTheme() {
        return this.theme_;
    }

    public void setTheme(TableTheme theme) {
        Color fc;
        this.theme_ = theme;
        if (this.theme_ == TableTheme.APPLE && PlatformUtilities.isMacintosh() && (fc = UIManager.getColor("Focus.color")) != null && fc.equals(GRAPHITE_FOCUS_COLOR)) {
            this.theme_ = TableTheme.APPLE_GRAPHITE;
        }
        if (this.theme_ == null) {
            this.setGridColor(UIManager.getColor("Table.gridColor"));
        } else {
            this.setGridColor(this.theme_.getGridColor());
            this.setShowVerticalLines(theme.getShowVerticalLines());
            this.setShowHorizontalLines(theme.getShowHorizontalLines());
        }
    }

    public Component prepareRenderer(TableCellRenderer tcr, int row, int col) {
        return this.prepareComponent(super.prepareRenderer(tcr, row, col), row, col, this.hasFocus(), this.isCellSelected(row, col), false);
    }

    public Component prepareEditor(TableCellEditor tce, int row, int col) {
        return this.prepareComponent(super.prepareEditor(tce, row, col), row, col, this.hasFocus(), this.isCellSelected(row, col), true);
    }

    protected Component prepareComponent(Component c, int row, int col, boolean focused, boolean selected, boolean editing) {
        if (editing) {
            c.setBackground(UIManager.getColor("TextField.background"));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else if (selected) {
            if (PlatformUtilities.isMacintosh() && !focused) {
                c.setBackground(UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR);
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(UIManager.getColor("Table.selectionBackground"));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        } else if (this.theme_ == null) {
            c.setBackground(UIManager.getColor("Table.background"));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(this.theme_.getBackground(row));
            c.setForeground(this.theme_.getForeground());
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            if (c instanceof JCheckBox) {
                if (PlatformUtilities.isMacintosh()) {
                    jc.setOpaque(false);
                    GuiUtilities.setSizeMini(jc);
                } else if (!PlatformUtilities.isWindows()) {
                    jc.setOpaque(true);
                }
            }
            if (editing) {
                jc.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                jc.setBorder(new GissTableCellBorder(this, row, col, selected, focused));
            }
            c.setEnabled(this.isEnabled());
        }
        return c;
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)gp;
            ColumnHeaderRenderer renderer1 = new ColumnHeaderRenderer();
            ColumnHeaderRenderer renderer2 = new ColumnHeaderRenderer();
            ColumnHeaderRenderer renderer3 = new ColumnHeaderRenderer();
            ColumnHeaderRenderer renderer4 = new ColumnHeaderRenderer();
            renderer1.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, CORNER_BORDER_COLOR_BOTTOM), BorderFactory.createMatteBorder(0, 0, 0, 1, CORNER_BORDER_COLOR_RIGHT)));
            renderer2.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, CORNER_BORDER_COLOR_BOTTOM), BorderFactory.createMatteBorder(0, 1, 0, 0, CORNER_BORDER_COLOR_LEFT)));
            renderer3.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, CORNER_BORDER_COLOR_BOTTOM), BorderFactory.createMatteBorder(0, 0, 0, 1, CORNER_BORDER_COLOR_RIGHT)));
            renderer4.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, CORNER_BORDER_COLOR_BOTTOM), BorderFactory.createMatteBorder(0, 1, 0, 0, CORNER_BORDER_COLOR_LEFT)));
            sp.setCorner("UPPER_LEFT_CORNER", renderer1);
            sp.setCorner("UPPER_RIGHT_CORNER", renderer2);
            sp.setCorner("LOWER_LEFT_CORNER", renderer3);
            sp.setCorner("LOWER_RIGHT_CORNER", renderer4);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            int rows = height / this.rowHeight;
            if (this.theme_ != null) {
                for (int i = rowCount; i <= rows; ++i) {
                    g.setColor(this.theme_.getBackground(i));
                    g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
                }
            }
            if (this.getShowVerticalLines()) {
                g.setColor(this.getGridColor());
                TableColumnModel columnModel = this.getColumnModel();
                int x = 0;
                for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, height);
                }
            }
            if (this.getShowHorizontalLines()) {
                g.setColor(this.getGridColor());
                int y = rowCount * this.rowHeight - 1;
                g.drawLine(clip.x, y, clip.width, y);
                for (int i = rowCount; i <= rows; ++i) {
                    y = (i + 1) * this.rowHeight - 1;
                    g.drawLine(clip.x, y, clip.width, y);
                }
            }
        }
    }

    public void repaintHeaders() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
        if (this.rowHeader_ != null) {
            this.rowHeader_.repaint();
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean isColumnVisible(int col) {
        if (col < 0) {
            throw new IndexOutOfBoundsException(col + " < 0");
        }
        if (col >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException(col + " >= " + this.getColumnCount());
        }
        Rectangle r = this.getCellRect(-1, col, true);
        Insets ins = this.getInsets();
        r.y = ins.top;
        r.height = this.getHeight() - ins.top - ins.bottom;
        Rectangle tRect = this.getVisibleRect();
        return tRect.x <= r.x && tRect.x + tRect.width >= r.x + r.width;
    }

    public boolean isRowVisible(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException(row + " < 0");
        }
        if (row >= this.getRowCount()) {
            throw new IndexOutOfBoundsException(row + " >= " + this.getRowCount());
        }
        Rectangle r = this.getCellRect(row, -1, true);
        Insets ins = this.getInsets();
        r.x = ins.left;
        r.width = this.getWidth() - ins.left - ins.right;
        Rectangle tRect = this.getVisibleRect();
        return tRect.y <= r.y && tRect.y + tRect.height >= r.y + r.height;
    }

    public void makeColumnVisible(int col) {
        if (this.isColumnVisible(col)) {
            return;
        }
        int rowCount = this.getRowCount();
        int row = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (!this.isRowVisible(i)) continue;
            row = i;
            break;
        }
        Rectangle r = this.getCellRect(row, col, true);
        this.scrollRectToVisible(r);
    }

    public void makeRowVisible(int row) {
        if (this.isRowVisible(row)) {
            return;
        }
        int colCount = this.getColumnCount();
        int col = 0;
        for (int i = 0; i < colCount; ++i) {
            if (!this.isColumnVisible(i)) continue;
            col = i;
            break;
        }
        Rectangle r = this.getCellRect(row, col, true);
        this.scrollRectToVisible(r);
    }

    public void selectColumns(int col0, int col1) {
        int rowCount = this.getRowCount();
        this.requestFocus();
        this.setColumnSelectionInterval(col0, col1);
        if (rowCount > 0) {
            this.setRowSelectionInterval(0, rowCount - 1);
            this.makeColumnVisible(col1);
        }
        this.repaint();
    }

    public void selectRows(int row0, int row1) {
        int colCount = this.getColumnCount();
        this.requestFocus();
        this.setRowSelectionInterval(row0, row1);
        if (colCount > 0) {
            this.setColumnSelectionInterval(0, colCount - 1);
            this.makeRowVisible(row1);
        }
        this.repaint();
    }

    public void clearSelection() {
        super.clearSelection();
        this.clearColumnHeaders();
        this.clearRowHeaders();
    }

    public void clearColumnHeaders() {
        TableCellRenderer r = this.getColumnHeaderRenderer(0);
        if (r instanceof ColumnHeaderRenderer) {
            ((ColumnHeaderRenderer)r).clear();
        }
        this.repaintHeaders();
    }

    public void clearRowHeaders() {
        if (this.rowHeader_ == null) {
            return;
        }
        int rowCount = this.getRowCount();
        if (rowCount < 1) {
            return;
        }
        TableCellRenderer r = this.rowHeader_.getCellRenderer(0, 0);
        if (r instanceof RowHeaderRenderer) {
            RowHeaderRenderer trhr = (RowHeaderRenderer)r;
            trhr.clear();
        }
        this.repaintHeaders();
    }

    public TableCellRenderer getColumnHeaderRenderer(int col) {
        JTableHeader colHeader = this.getTableHeader();
        TableColumnModel tcm = this.getColumnModel();
        try {
            TableColumn tc = tcm.getColumn(col);
            TableCellRenderer r = tc.getHeaderRenderer();
            if (r == null) {
                r = colHeader.getDefaultRenderer();
            }
            return r;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public TableCellRenderer getRowHeaderRenderer(int row) {
        if (this.rowHeader_ == null) {
            return null;
        }
        return this.rowHeader_.getCellRenderer(row, 0);
    }
}

