/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import gov.nasa.giss.gui.label.MultiLineLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class MultiLineLabelUI
extends ComponentUI {
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        Color oc = g.getColor();
        MultiLineLabel label = (MultiLineLabel)c;
        if (label.isEnabled()) {
            g.setColor(label.getForeground());
            this.paintText(label, g);
        } else {
            g.setColor(label.getBackground().brighter());
            this.paintText(label, g);
            g.translate(1, 1);
            g.setColor(label.getBackground().darker());
            this.paintText(label, g);
            g.translate(-1, -1);
        }
        g.setColor(oc);
    }

    protected void paintText(MultiLineLabel label, Graphics g) {
        TextInfo info = this.measure(label);
        String[] lines = info.getLines();
        Dimension size = label.getSize();
        Insets ins = label.getInsets();
        int halign = label.getHorizontalAlignment();
        int valign = label.getVerticalAlignment();
        int y = valign == 0 ? (size.height - lines.length * info.getLineHeight()) / 2 : (valign == 3 ? size.height - ins.bottom - (lines.length - 1) * info.getLineHeight() : ins.top + info.getLineAscent());
        int i = 0;
        while (i < lines.length) {
            int x = halign == 0 ? (size.width - info.getLineWidths()[i]) / 2 : (halign == 4 ? size.width - ins.right - info.getLineWidths()[i] : ins.left);
            g.drawString(lines[i], x, y);
            ++i;
            y += info.getLineHeight();
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        TextInfo info = this.measure(c);
        Insets ins = c.getInsets();
        return new Dimension(info.getMaxWidth() + ins.left + ins.right, info.getLines().length * info.getLineHeight() + ins.top + ins.bottom);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(5000, 5000);
    }

    private TextInfo measure(JComponent c) {
        MultiLineLabel label = (MultiLineLabel)c;
        return new TextInfo(label);
    }

    protected class TextInfo {
        private int lineAscent_;
        private int lineHeight_;
        private int numLines_;
        private String[] lines_;
        private int[] lineWidths_;
        private int maxWidth_;

        protected TextInfo(MultiLineLabel label) {
            FontMetrics fm = label.getFontMetrics(label.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.maxWidth_ = 0;
            String text = label.getText().replaceFirst("^\\n+", "");
            this.lines_ = text.split("\\n");
            this.numLines_ = this.lines_.length;
            this.lineWidths_ = new int[this.numLines_];
            for (int i = 0; i < this.numLines_; ++i) {
                this.lineWidths_[i] = fm.stringWidth(this.lines_[i]);
                this.maxWidth_ = Math.max(this.maxWidth_, this.lineWidths_[i]);
            }
        }

        public int getLineAscent() {
            return this.lineAscent_;
        }

        public int getLineHeight() {
            return this.lineHeight_;
        }

        public String[] getLines() {
            return this.lines_;
        }

        public int[] getLineWidths() {
            return this.lineWidths_;
        }

        public int getMaxWidth() {
            return this.maxWidth_;
        }
    }
}

