/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import com.explodingpixels.macwidgets.plaf.HudTextFieldUI;
import gov.nasa.giss.gui.HudUtilities;
import gov.nasa.giss.gui.plaf.GissHudSpinnerButton;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class GissHudSpinnerUI
extends BasicSpinnerUI {
    private Component nextButton_;
    private Component prevButton_;

    protected void installDefaults() {
        super.installDefaults();
        HudUtilities.initComponent(this.spinner);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        if (!(editor instanceof JSpinner.DefaultEditor)) {
            throw new RuntimeException("Unexpected createEditor response.");
        }
        ((JSpinner.DefaultEditor)editor).getTextField().setUI(new HudTextFieldUI());
        Component pb = this.createPreviousButton();
        Component nb = this.createNextButton();
        int bh = pb.getPreferredSize().height + nb.getPreferredSize().height;
        int dh = bh - editor.getPreferredSize().height + 1;
        if (dh > 0) {
            editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(dh / 2 + 1, 0, dh / 2 + 1, 0), editor.getBorder()));
        }
        return editor;
    }

    protected Component createPreviousButton() {
        if (this.prevButton_ != null) {
            return this.prevButton_;
        }
        GissHudSpinnerButton prevButton_ = new GissHudSpinnerButton(this.spinner, 5);
        this.installPreviousButtonListeners(prevButton_);
        return prevButton_;
    }

    protected Component createNextButton() {
        if (this.nextButton_ != null) {
            return this.nextButton_;
        }
        GissHudSpinnerButton nextButton_ = new GissHudSpinnerButton(this.spinner, 1);
        this.installNextButtonListeners(nextButton_);
        return nextButton_;
    }
}

