/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.HudUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSpinner;

public class GissHudSpinnerButton
extends JButton {
    private static final int TB_MARGIN = 1;
    private static final int LR_MARGIN = 3;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    private static final int ARROW_WIDTH = 4;
    private static final int ARROW_HEIGHT = 4;
    private JSpinner spinner_;
    private int direction_;
    private static Color dividerColor_;

    public GissHudSpinnerButton(JSpinner spinner, int direction) {
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.spinner_ = spinner;
        this.direction_ = direction;
        HudUtilities.initComponent(this);
        int tm = this.direction_ == 5 ? 0 : 1;
        int bm = this.direction_ == 5 ? 2 : 0;
        this.setBorder(BorderFactory.createEmptyBorder(tm, 3, bm, 3));
        if (dividerColor_ == null) {
            int r = HudPaintingUtils.BORDER_COLOR.getRed();
            int g = HudPaintingUtils.BORDER_COLOR.getGreen();
            int b = HudPaintingUtils.BORDER_COLOR.getBlue();
            dividerColor_ = new Color(r, g, b, 104);
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GuiUtilities.updateGraphicsIfDisabled(g2d, this.spinner_);
        int w = 10;
        int h = 10;
        Insets ins = this.getInsets();
        if (this.direction_ == 5) {
            g2d.translate(ins.left, -10);
        } else {
            g2d.translate(ins.left, this.getHeight() - 10);
        }
        HudPaintingUtils.paintHudControlBackground(g2d, this, 10, 20, HudPaintingUtils.Roundedness.COMBO_BUTTON);
        if (this.direction_ == 5) {
            g2d.translate(0, 10);
            g2d.setColor(dividerColor_);
            g2d.drawLine(0, 0, 9, 0);
        }
        g2d.setColor(HudUtilities.FONT_COLOR);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        if (this.direction_ == 5) {
            g2d.translate(3.0, 3.0);
            path.lineTo(4.0f, 0.0f);
            path.lineTo(2.0f, 4.0f);
        } else {
            g2d.translate(3.0, 8.0);
            path.lineTo(4.0f, 0.0f);
            path.lineTo(2.0f, -4.0f);
        }
        path.closePath();
        g2d.fill(path);
        g2d.dispose();
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(10 + ins.left + ins.right, 10 + ins.top + ins.bottom);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

