/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import com.explodingpixels.macwidgets.plaf.HudButtonUI;
import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.HudUtilities;
import gov.nasa.giss.gui.color.ColorIcon;
import gov.nasa.giss.gui.color.ColorInfo;
import gov.nasa.giss.gui.plaf.GissComboPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class GissHudComboBoxUI
extends BasicComboBoxUI {
    private static final int LEFT_MARGIN = 7;
    private static final int RIGHT_MARGIN = 19;
    private static final int DEFAULT_WIDTH = 100;
    private ActionListener selectedItemChangedActionListener_ = this.createSelectedItemChangedActionListener();
    private PopupMenuListener popupMenuListener_ = this.createPopupMenuListener();

    protected JButton createArrowButton() {
        JButton arrowButton = new JButton("");
        arrowButton.setModel(this.createButtonModel());
        arrowButton.setUI(new HudButtonUI(HudPaintingUtils.Roundedness.COMBO_BUTTON));
        Insets currentInsets = arrowButton.getInsets();
        arrowButton.setBorder(BorderFactory.createEmptyBorder(currentInsets.top, 7, currentInsets.bottom, 19));
        arrowButton.setHorizontalAlignment(2);
        return arrowButton;
    }

    protected ComboPopup createPopup() {
        GissComboPopup popup = new GissComboPopup(this.comboBox);
        popup.setFont(HudUtilities.getFont().deriveFont(0));
        return popup;
    }

    protected void installDefaults() {
        super.installDefaults();
        HudUtilities.initComponent(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addActionListener(this.createComboBoxListener());
        this.comboBox.addActionListener(this.selectedItemChangedActionListener_);
        this.comboBox.addPopupMenuListener(this.popupMenuListener_);
    }

    protected void uninstallListeners() {
        this.comboBox.removeActionListener(this.selectedItemChangedActionListener_);
    }

    protected void installComponents() {
        super.installComponents();
        this.updateDisplayedItem();
    }

    private int getDisplayWidth(Object object) {
        String text;
        int isize;
        assert (object != null) : "The given object cannot be null";
        if (object instanceof Color) {
            int isize2 = this.comboBox.getFont().getSize() - 1;
            return isize2;
        }
        if (object instanceof ColorInfo) {
            isize = this.comboBox.getFont().getSize() - 1;
            ColorInfo cmi = (ColorInfo)object;
            text = cmi.getName();
        } else {
            text = object.toString();
            isize = 0;
        }
        FontMetrics fontMetrics = this.comboBox.getFontMetrics(this.comboBox.getFont());
        return isize + 8 + fontMetrics.stringWidth(text);
    }

    protected void updateDisplayedItem() {
        Object item = this.comboBox.getSelectedItem();
        if (item == null) {
            this.arrowButton.setText(" ");
            this.arrowButton.setIcon(null);
        } else if (item instanceof Color) {
            int isize = this.comboBox.getFont().getSize() - 1;
            Color c = (Color)item;
            ColorIcon icon = new ColorIcon(c, isize);
            this.arrowButton.setText(" ");
            this.arrowButton.setIcon(icon);
        } else if (item instanceof ColorInfo) {
            ColorInfo cmi = (ColorInfo)item;
            int isize = this.comboBox.getFont().getSize() - 1;
            Color c = cmi.getColor();
            ColorIcon icon = new ColorIcon(c, isize);
            this.arrowButton.setText(cmi.getName());
            this.arrowButton.setIcon(icon);
        } else {
            this.arrowButton.setText(item.toString());
            this.arrowButton.setIcon(null);
        }
        this.arrowButton.setVerticalTextPosition(0);
        this.arrowButton.setHorizontalTextPosition(4);
    }

    private ActionListener createSelectedItemChangedActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GissHudComboBoxUI.this.updateDisplayedItem();
            }
        };
    }

    private ActionListener createComboBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GissHudComboBoxUI.this.updateDisplayedItem();
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                GissHudComboBoxUI.this.arrowButton.getModel().setPressed(true);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GissHudComboBoxUI.this.arrowButton.getModel().setPressed(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    private ButtonModel createButtonModel() {
        return new DefaultButtonModel(){

            public boolean isPressed() {
                return super.isPressed() || GissHudComboBoxUI.this.isPopupVisible(GissHudComboBoxUI.this.comboBox);
            }
        };
    }

    protected ListCellRenderer createRenderer() {
        return new JComboBox().getRenderer();
    }

    public Dimension getMinimumSize(JComponent c) {
        int width = this.getDisplaySize().width;
        int height = this.arrowButton.getPreferredSize().height;
        return new Dimension(width, height);
    }

    protected Dimension getDefaultSize() {
        JButton button = new JButton("Button");
        button.setUI(new HudButtonUI());
        return new Dimension(100, button.getPreferredSize().height);
    }

    public void paint(Graphics g, JComponent c) {
        GuiUtilities.updateGraphicsIfDisabled((Graphics2D)g, c);
        super.paint(g, c);
        Graphics2D g2d = (Graphics2D)g.create();
        this.paintUpDownArrowsIcon(g2d);
        g2d.dispose();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected Dimension getDisplaySize() {
        int maxWidth = this.comboBox.getPrototypeDisplayValue() != null ? this.getDisplayWidth(this.comboBox.getPrototypeDisplayValue()) : (this.comboBox.getItemCount() > 0 ? this.getMaxComboBoxModelDisplayWidth() : this.getDefaultSize().width);
        Insets arrowButtonInsets = this.arrowButton.getInsets();
        return new Dimension(maxWidth += arrowButtonInsets.left + arrowButtonInsets.right, this.arrowButton.getPreferredSize().height);
    }

    private int getMaxComboBoxModelDisplayWidth() {
        int maxWidth = 0;
        int isize = this.comboBox.getModel().getSize();
        for (int i = 0; i < isize; ++i) {
            int itemWidth = this.getDisplayWidth(this.comboBox.getModel().getElementAt(i));
            maxWidth = Math.max(maxWidth, itemWidth);
        }
        return maxWidth;
    }

    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
                throw new UnsupportedOperationException("Operation is not supported.");
            }

            public void removeLayoutComponent(Component comp) {
                throw new UnsupportedOperationException("Operation is not supported.");
            }

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getPreferredSize().width, ((GissHudComboBoxUI)GissHudComboBoxUI.this).arrowButton.getPreferredSize().height);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            public void layoutContainer(Container parent) {
                int buttonHeight = ((GissHudComboBoxUI)GissHudComboBoxUI.this).arrowButton.getPreferredSize().height;
                int y = parent.getHeight() / 2 - buttonHeight / 2;
                GissHudComboBoxUI.this.arrowButton.setBounds(0, y, parent.getWidth(), buttonHeight);
            }
        };
    }

    private int calculateArrowButtonVisualVerticalCenter() {
        return (this.comboBox.getHeight() - 2) / 2;
    }

    private void paintUpDownArrowsIcon(Graphics2D graphics) {
        Insets arrowButtonInsets = this.arrowButton.getInsets();
        int arrowButtonHeight = this.arrowButton.getHeight();
        int centerX = this.arrowButton.getWidth() - arrowButtonInsets.right / 2;
        int centerY = this.calculateArrowButtonVisualVerticalCenter();
        int verticalDistanceBetweenArrows = (int)((double)arrowButtonHeight * 0.125);
        int arrowSideLength = verticalDistanceBetweenArrows * 2;
        int upArrowX = centerX - arrowSideLength / 2;
        int upArrowY = centerY - verticalDistanceBetweenArrows / 2;
        graphics.setColor(HudUtilities.FONT_COLOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(upArrowX, upArrowY);
        graphics.fill(GissHudComboBoxUI.createUpArrow(arrowSideLength));
        graphics.translate(0, verticalDistanceBetweenArrows);
        graphics.fill(GissHudComboBoxUI.createDownArrow(arrowSideLength));
    }

    private static GeneralPath createUpArrow(int arrowSideLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(arrowSideLength, 0.0f);
        path.lineTo(arrowSideLength / 2, -arrowSideLength);
        path.closePath();
        return path;
    }

    private static GeneralPath createDownArrow(int arrowSideLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(arrowSideLength, 0.0f);
        path.lineTo(arrowSideLength / 2, arrowSideLength);
        path.closePath();
        return path;
    }
}

