/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.plaf.GissComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.MenuSelectionManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.plaf.basic.ComboPopup;

public class GissComboPopup
extends JPopupMenu
implements ComboPopup {
    private static final Color ENABLED_ARROW_COLOR = new Color(90, 90, 90);
    private static final Color DISABLED_ARROW_COLOR = new Color(90, 90, 90, 64);
    private static final int MINIMUM_ROWS_VISIBLE = 16;
    private int firstRow_;
    private Timer scrollTimer_;
    private JComboBox parentCB_;
    private ItemPanel ipanel_;
    private ScrollArrow topArrow_;
    private ScrollArrow bottomArrow_;
    private boolean showingArrows_;
    private PopupList list_;
    private BogusList bogusList_;

    public GissComboPopup(JComboBox cb) {
        this.parentCB_ = cb;
        this.ipanel_ = new ItemPanel();
        this.insert(this.ipanel_, 0);
        this.setFocusable(false);
    }

    private void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        RepaintManager rpm = RepaintManager.currentManager(this);
        if (rpm != null) {
            rpm.markCompletelyDirty(this);
        } else {
            System.err.println("WARNING: RepaintManager is null!");
        }
        this.repaint();
    }

    public void highlight(int index) {
        int cbsize = this.parentCB_.getItemCount();
        if (index < 0 || index >= cbsize) {
            return;
        }
        this.list_.scroll(index - this.firstRow_);
        this.bogusList_.repaint();
    }

    public void show() {
        this.show(-1);
    }

    public void show(int index) {
        this.ipanel_.clearAndFill(index);
        this.pack();
        Insets pins = this.parentCB_.getInsets();
        int dx = this.parentCB_.getPreferredSize().width - this.getPreferredSize().width;
        int hindex = this.list_.getHighlightedIndex();
        Rectangle r = this.list_.getCellBounds(0, 0);
        int dy = -pins.top - hindex * r.height;
        if (this.showingArrows_) {
            dy -= this.topArrow_.getPreferredSize().height;
        }
        this.show(this.parentCB_, dx, dy);
    }

    public void hide() {
        this.setVisible(false);
        this.list_.setHighlightedIndex(-1);
        this.bogusList_.repaint();
    }

    public JList getList() {
        return null;
    }

    public MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (GissComboPopup.this.parentCB_.isEnabled()) {
                    GissComboPopup.this.togglePopup();
                }
            }

            public void mouseReleased(MouseEvent e) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            }
        };
    }

    public MouseMotionListener getMouseMotionListener() {
        return new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            }
        };
    }

    public KeyListener getKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int kcode = e.getKeyCode();
                if (e.isMetaDown() || e.isControlDown() || e.isAltDown() || kcode == 16 || kcode == 20 || kcode == 127 || kcode >= 112 && kcode <= 123) {
                    return;
                }
                e.consume();
                if (!GissComboPopup.this.isVisible()) {
                    GissComboPopup.this.show();
                    return;
                }
                if (kcode == 27) {
                    GissComboPopup.this.hide();
                    return;
                }
                int oldIdx = GissComboPopup.this.list_.getHighlightedIndex();
                if (kcode == 10 || kcode == 32) {
                    if (oldIdx != -1) {
                        int cindex = GissComboPopup.this.firstRow_ + oldIdx;
                        Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(cindex);
                        GissComboPopup.this.parentCB_.getModel().setSelectedItem(item);
                    }
                    GissComboPopup.this.hide();
                    return;
                }
                if (kcode != 40 && kcode != 38) {
                    return;
                }
                int newIdx = -1;
                int cbsize = GissComboPopup.this.parentCB_.getItemCount();
                int lsize = GissComboPopup.this.list_.getModel().getSize();
                if (oldIdx < 0) {
                    if (kcode == 40) {
                        GissComboPopup.this.list_.scrollToTop();
                        GissComboPopup.this.bogusList_.repaint();
                        newIdx = 0;
                    } else {
                        GissComboPopup.this.list_.scrollToBottom();
                        GissComboPopup.this.bogusList_.repaint();
                        newIdx = lsize - 1;
                    }
                } else if (kcode == 40) {
                    newIdx = oldIdx + 1;
                } else if (kcode == 38) {
                    newIdx = oldIdx - 1;
                }
                if (newIdx == -1) {
                    if (GissComboPopup.this.firstRow_ > 0) {
                        GissComboPopup.this.list_.scrollFromTop();
                        GissComboPopup.this.bogusList_.repaint();
                        ++oldIdx;
                        ++newIdx;
                    } else {
                        newIdx = oldIdx;
                    }
                } else if (newIdx == lsize) {
                    if (GissComboPopup.this.firstRow_ + lsize <= cbsize) {
                        GissComboPopup.this.list_.scrollFromBottom();
                        GissComboPopup.this.bogusList_.repaint();
                        --oldIdx;
                        --newIdx;
                    } else {
                        newIdx = oldIdx;
                    }
                }
                if (newIdx != oldIdx) {
                    GissComboPopup.this.list_.setHighlightedIndex(newIdx);
                    if (oldIdx > -1) {
                        GissComboPopup.this.list_.repaint(GissComboPopup.this.list_.getCellBounds(oldIdx, oldIdx));
                    }
                    if (newIdx > -1) {
                        GissComboPopup.this.list_.repaint(GissComboPopup.this.list_.getCellBounds(newIdx, newIdx));
                    }
                    GissComboPopup.this.bogusList_.repaint();
                }
            }

            public void keyReleased(KeyEvent e) {
                e.consume();
            }

            public void keyTyped(KeyEvent e) {
                e.consume();
            }
        };
    }

    public void uninstallingUI() {
    }

    class BogusList
    extends JComponent {
        private JList jl_;

        BogusList(JList jl) {
            this.jl_ = jl;
        }

        public void paintComponent(Graphics g) {
            this.jl_.paint(g);
        }

        public int locationToIndex(Point p) {
            return GissComboPopup.this.list_.locationToIndex(p);
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            if (e.getSource() != GissComboPopup.this.bogusList_) {
                return;
            }
            int index = GissComboPopup.this.bogusList_.locationToIndex(e.getPoint());
            GissComboPopup.this.list_.setHighlightedIndex(index);
            GissComboPopup.this.bogusList_.repaint();
        }

        public void mouseExited(MouseEvent e) {
            GissComboPopup.this.list_.setHighlightedIndex(-1);
            GissComboPopup.this.bogusList_.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getSource() != GissComboPopup.this.bogusList_) {
                return;
            }
            int index = GissComboPopup.this.bogusList_.locationToIndex(e.getPoint());
            GissComboPopup.this.list_.setHighlightedIndex(index);
            GissComboPopup.this.bogusList_.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (e == null) {
                return;
            }
            if (e.getSource() != GissComboPopup.this.bogusList_) {
                return;
            }
            int index = GissComboPopup.this.bogusList_.locationToIndex(e.getPoint());
            if (index > -1) {
                int cindex = GissComboPopup.this.firstRow_ + index;
                Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(cindex);
                GissComboPopup.this.parentCB_.getModel().setSelectedItem(item);
            }
            GissComboPopup.this.parentCB_.setPopupVisible(false);
        }
    }

    private class ScrollHandler
    implements ActionListener {
        private ScrollDirection direction_;

        ScrollHandler(ScrollDirection direction) {
            this.direction_ = direction;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.direction_ == ScrollDirection.FROM_TOP) {
                GissComboPopup.this.list_.scrollFromTop();
            } else {
                GissComboPopup.this.list_.scrollFromBottom();
            }
            GissComboPopup.this.bogusList_.repaint();
        }
    }

    private class ScrollArrowMouseHandler
    extends MouseInputAdapter {
        ScrollArrow arrow_;
        ScrollDirection direction_ = ScrollDirection.FROM_TOP;

        ScrollArrowMouseHandler(ScrollArrow arrow, ScrollDirection direction) {
            this.arrow_ = arrow;
            this.direction_ = direction;
        }

        public void mouseClicked(MouseEvent e) {
            if (GissComboPopup.this.scrollTimer_ != null) {
                GissComboPopup.this.scrollTimer_.stop();
            }
            GissComboPopup.this.parentCB_.setPopupVisible(false);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (this.direction_ == ScrollDirection.FROM_TOP) {
                GissComboPopup.this.list_.scrollFromTop();
            } else {
                GissComboPopup.this.list_.scrollFromBottom();
            }
            GissComboPopup.this.bogusList_.repaint();
            GissComboPopup.this.scrollTimer_ = new Timer(75, new ScrollHandler(this.direction_));
            GissComboPopup.this.scrollTimer_.start();
        }

        public void mouseExited(MouseEvent e) {
            if (GissComboPopup.this.scrollTimer_ != null) {
                GissComboPopup.this.scrollTimer_.stop();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (GissComboPopup.this.scrollTimer_ != null) {
                GissComboPopup.this.scrollTimer_.stop();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (GissComboPopup.this.scrollTimer_ != null) {
                GissComboPopup.this.scrollTimer_.stop();
            }
        }
    }

    private class ScrollArrow
    extends JComponent {
        ScrollDirection direction_ = ScrollDirection.FROM_TOP;

        ScrollArrow(ScrollDirection direction) {
            this.direction_ = direction;
            ScrollArrowMouseHandler amh = new ScrollArrowMouseHandler(this, direction);
            this.addMouseListener(amh);
            this.addMouseMotionListener(amh);
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(500, 16);
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.direction_ == ScrollDirection.FROM_TOP) {
                if (GissComboPopup.this.firstRow_ > 0) {
                    g2d.setColor(ENABLED_ARROW_COLOR);
                } else {
                    g2d.setColor(DISABLED_ARROW_COLOR);
                }
                g2d.translate((this.getSize().width - 10) / 2, 13);
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 0.0f);
                path.lineTo(10.0f, 0.0f);
                path.lineTo(5.0f, -8.0f);
                path.closePath();
                g2d.fill(path);
            } else {
                DefaultListModel lmodel = (DefaultListModel)GissComboPopup.this.list_.getModel();
                int cbsize = GissComboPopup.this.parentCB_.getItemCount();
                int lsize = lmodel.getSize();
                int lastRowP1 = GissComboPopup.this.firstRow_ + lsize;
                if (lastRowP1 < cbsize) {
                    g2d.setColor(ENABLED_ARROW_COLOR);
                } else {
                    g2d.setColor(DISABLED_ARROW_COLOR);
                }
                g2d.translate((this.getSize().width - 10) / 2, 3);
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 0.0f);
                path.lineTo(10.0f, 0.0f);
                path.lineTo(5.0f, 8.0f);
                path.closePath();
                g2d.fill(path);
            }
            g2d.dispose();
        }
    }

    class PopupListUI
    extends BasicListUI {
        PopupListUI() {
        }

        protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
            boolean cellHasFocus;
            Object svalue;
            boolean isSelected;
            Object value = dataModel.getElementAt(row);
            Component rc = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected = value.equals(svalue = GissComboPopup.this.parentCB_.getModel().getSelectedItem()), cellHasFocus = row == ((PopupList)this.list).getHighlightedIndex());
            if (rc instanceof GissComboBoxRenderer) {
                ((GissComboBoxRenderer)rc).setOffset(true);
            }
            int cx = rowBounds.x;
            int cy = rowBounds.y;
            int cw = rowBounds.width;
            int ch = rowBounds.height;
            this.rendererPane.paintComponent(g, rc, this.list, cx, cy, cw, ch, true);
        }
    }

    class PopupList
    extends JList {
        private int hIndex_;

        PopupList(ListModel lm) {
            super(lm);
            this.hIndex_ = -1;
        }

        public int getHighlightedIndex() {
            return this.hIndex_;
        }

        public void setHighlightedIndex(int index) {
            int oldIdx = this.hIndex_;
            this.hIndex_ = index;
            if (oldIdx > -1) {
                try {
                    this.repaint(this.getCellBounds(oldIdx, oldIdx));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.hIndex_ > -1) {
                this.repaint(this.getCellBounds(this.hIndex_, this.hIndex_));
            }
        }

        private void scroll(int index) {
            DefaultListModel lmodel = (DefaultListModel)this.getModel();
            int cbsize = GissComboPopup.this.parentCB_.getItemCount();
            int lsize = lmodel.getSize();
            if (index < 0) {
                int count = -index;
                GissComboPopup.this.firstRow_ -= count;
                if (count < lsize) {
                    lmodel.removeRange(lsize - count, lsize - 1);
                    for (int i = count - 1; i >= 0; --i) {
                        Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(GissComboPopup.this.firstRow_ + i);
                        lmodel.add(0, item);
                    }
                } else {
                    lmodel.removeRange(0, lsize - 1);
                    for (int i = 0; i < lsize; ++i) {
                        Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(GissComboPopup.this.firstRow_ + i);
                        lmodel.addElement(item);
                    }
                }
                index = 0;
                GissComboPopup.this.repaint();
            } else if (index >= lsize) {
                int count = index - lsize + 1;
                GissComboPopup.this.firstRow_ += count;
                int remove = count < lsize ? count : lsize;
                int istart = count < lsize ? lsize - count : 0;
                int iend = count < lsize ? lsize : lsize;
                lmodel.removeRange(0, remove - 1);
                for (int i = istart; i < iend; ++i) {
                    Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(GissComboPopup.this.firstRow_ + i);
                    lmodel.addElement(item);
                }
                index = lsize - 1;
                GissComboPopup.this.repaint();
            }
            this.setHighlightedIndex(index);
        }

        private void scrollToTop() {
            if (GissComboPopup.this.firstRow_ == 0) {
                return;
            }
            DefaultListModel lmodel = (DefaultListModel)this.getModel();
            int lsize = lmodel.getSize();
            int count = Math.min(lsize, GissComboPopup.this.firstRow_);
            lmodel.removeRange(lsize - count, lsize - 1);
            for (int i = count - 1; i >= 0; --i) {
                Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(i);
                lmodel.add(0, item);
            }
            GissComboPopup.this.firstRow_ = 0;
            GissComboPopup.this.repaint();
        }

        private void scrollToBottom() {
            DefaultListModel lmodel = (DefaultListModel)this.getModel();
            int cbsize = GissComboPopup.this.parentCB_.getItemCount();
            int lsize = lmodel.getSize();
            int lastRowP1 = GissComboPopup.this.firstRow_ + lsize;
            if (lastRowP1 == cbsize) {
                return;
            }
            int count = Math.min(lsize, cbsize - lastRowP1);
            lmodel.removeRange(0, count - 1);
            for (int i = cbsize - count; i < cbsize; ++i) {
                Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(i);
                lmodel.addElement(item);
            }
            GissComboPopup.this.firstRow_ = cbsize - lsize;
            GissComboPopup.this.repaint();
        }

        private void scrollFromTop() {
            if (GissComboPopup.this.firstRow_ == 0) {
                return;
            }
            --GissComboPopup.this.firstRow_;
            DefaultListModel lmodel = (DefaultListModel)this.getModel();
            lmodel.removeElementAt(lmodel.getSize() - 1);
            Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(GissComboPopup.this.firstRow_);
            lmodel.add(0, item);
            if (item.equals(GissComboPopup.this.parentCB_.getModel().getSelectedItem())) {
                this.setSelectedIndex(0);
            }
            this.validate();
            GissComboPopup.this.repaint();
        }

        private void scrollFromBottom() {
            DefaultListModel lmodel = (DefaultListModel)this.getModel();
            int cbsize = GissComboPopup.this.parentCB_.getItemCount();
            int lsize = lmodel.getSize();
            int lastRowP1 = GissComboPopup.this.firstRow_ + lsize;
            if (lastRowP1 >= cbsize) {
                return;
            }
            ++GissComboPopup.this.firstRow_;
            lmodel.removeElementAt(0);
            Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(lastRowP1);
            lmodel.addElement(item);
            if (item.equals(GissComboPopup.this.parentCB_.getModel().getSelectedItem())) {
                this.setSelectedIndex(lmodel.getSize() - 1);
            }
            this.validate();
            GissComboPopup.this.repaint();
        }
    }

    class ItemPanel
    extends JPanel {
        ItemPanel() {
            this.setBorder(null);
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 1));
            DefaultListModel lmodel = new DefaultListModel();
            GissComboPopup.this.list_ = new PopupList(lmodel);
            GissComboPopup.this.bogusList_ = new BogusList(GissComboPopup.this.list_);
            GissComboPopup.this.list_.setUI(new PopupListUI());
            GissComboPopup.this.list_.setSelectionMode(0);
            ListMouseHandler lmh = new ListMouseHandler();
            GissComboPopup.this.bogusList_.addMouseListener(lmh);
            GissComboPopup.this.bogusList_.addMouseMotionListener(lmh);
            GissComboPopup.this.list_.addKeyListener(GissComboPopup.this.getKeyListener());
        }

        private void clearAndFill(int index) {
            this.removeAll();
            DefaultListModel lmodel = (DefaultListModel)GissComboPopup.this.list_.getModel();
            lmodel.removeAllElements();
            ListCellRenderer lcr = GissComboPopup.this.parentCB_.getRenderer();
            GissComboPopup.this.list_.setCellRenderer(lcr);
            GissComboPopup.this.list_.setFont(((JComponent)((Object)lcr)).getFont());
            Object sampleObject = GissComboPopup.this.parentCB_.getModel().getElementAt(0);
            lmodel.addElement(sampleObject);
            JComponent sampleItem = (JComponent)lcr.getListCellRendererComponent(GissComboPopup.this.list_, sampleObject, 0, false, false);
            int dy = sampleItem.getPreferredSize().height;
            Point p0 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p0, GissComboPopup.this.parentCB_);
            int dyAbove = p0.y - 30;
            int dyTotal = GuiUtilities.getMainScreenBounds().height - 50;
            int dyBelow = dyTotal - dyAbove - dy;
            int canFitAbove = dyAbove / dy;
            int canFitTotal = dyTotal / dy;
            int canFitBelow = dyBelow / dy;
            int sindex = GissComboPopup.this.parentCB_.getSelectedIndex();
            int hindex = index > -1 ? index : sindex;
            Object sitem = GissComboPopup.this.parentCB_.getItemAt(sindex);
            Object hitem = GissComboPopup.this.parentCB_.getItemAt(hindex);
            int totalRows = GissComboPopup.this.parentCB_.getItemCount();
            GissComboPopup.this.showingArrows_ = hindex - canFitAbove > 0 || hindex + canFitBelow < totalRows - 1;
            GissComboPopup.this.firstRow_ = Math.max(0, hindex - canFitAbove);
            if (GissComboPopup.this.firstRow_ > 0 && GissComboPopup.this.firstRow_ < hindex) {
                ++GissComboPopup.this.firstRow_;
            }
            int lastRowP1 = Math.min(hindex + canFitBelow, totalRows);
            int visRows = lastRowP1 - GissComboPopup.this.firstRow_;
            if (GissComboPopup.this.showingArrows_ && visRows < 16) {
                if (totalRows < 16) {
                    GissComboPopup.this.showingArrows_ = false;
                    GissComboPopup.this.firstRow_ = 0;
                    visRows = totalRows;
                    lastRowP1 = totalRows;
                } else {
                    int diff = 16 - visRows;
                    if (canFitAbove > canFitBelow) {
                        lastRowP1 += diff;
                    } else {
                        GissComboPopup.this.firstRow_ -= diff;
                    }
                    GissComboPopup.this.firstRow_ = Math.max(0, GissComboPopup.this.firstRow_);
                    lastRowP1 = Math.min(lastRowP1, totalRows);
                    visRows = lastRowP1 - GissComboPopup.this.firstRow_;
                }
            }
            if (GissComboPopup.this.showingArrows_) {
                if (GissComboPopup.this.topArrow_ == null) {
                    GissComboPopup.this.topArrow_ = new ScrollArrow(ScrollDirection.FROM_TOP);
                }
                this.add(GissComboPopup.this.topArrow_);
                GissComboPopup.this.topArrow_.setVisible(true);
            }
            lmodel.removeAllElements();
            for (int i = GissComboPopup.this.firstRow_; i < lastRowP1; ++i) {
                Object item = GissComboPopup.this.parentCB_.getModel().getElementAt(i);
                lmodel.addElement(item);
                if (item.equals(sitem)) {
                    GissComboPopup.this.list_.setSelectedIndex(i - GissComboPopup.this.firstRow_);
                }
                if (!item.equals(hitem)) continue;
                GissComboPopup.this.list_.setHighlightedIndex(i - GissComboPopup.this.firstRow_);
            }
            this.add(GissComboPopup.this.bogusList_);
            if (GissComboPopup.this.showingArrows_) {
                if (GissComboPopup.this.bottomArrow_ == null) {
                    GissComboPopup.this.bottomArrow_ = new ScrollArrow(ScrollDirection.FROM_BOTTOM);
                }
                this.add(GissComboPopup.this.bottomArrow_);
                GissComboPopup.this.bottomArrow_.setVisible(true);
            }
            int popupWidth = ((GissComboPopup)GissComboPopup.this).parentCB_.getPreferredSize().width + 5;
            Insets insets = this.getInsets();
            int popupHeight = insets.top + dy * visRows + insets.bottom;
            if (GissComboPopup.this.showingArrows_) {
                popupHeight += ((GissComboPopup)GissComboPopup.this).topArrow_.getPreferredSize().height + ((GissComboPopup)GissComboPopup.this).bottomArrow_.getPreferredSize().height;
            }
            Dimension size = new Dimension(popupWidth, popupHeight);
            this.setSize(size);
            this.setPreferredSize(size);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
            Dimension lsize = new Dimension(size.width, dy * visRows);
            GissComboPopup.this.list_.setSize(lsize);
            GissComboPopup.this.list_.setPreferredSize(lsize);
            GissComboPopup.this.list_.setMaximumSize(lsize);
            GissComboPopup.this.list_.setMinimumSize(lsize);
            GissComboPopup.this.bogusList_.setSize(lsize);
            GissComboPopup.this.bogusList_.setPreferredSize(lsize);
            GissComboPopup.this.bogusList_.setMaximumSize(lsize);
            GissComboPopup.this.bogusList_.setMinimumSize(lsize);
            this.invalidate();
            this.validate();
            GissComboPopup.this.pack();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollDirection {
        FROM_TOP,
        FROM_BOTTOM;

    }
}

