/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.plaf.GissComboBoxRenderer;
import gov.nasa.giss.gui.plaf.GissComboPopup;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class GissComboBoxUI
extends BasicComboBoxUI {
    private static final int DEFAULT_WIDTH = 100;
    private static long timeFactor = 1000L;
    private PopupMenuListener popupMenuListener_ = this.createPopupMenuListener();
    protected JComboBox falseButton_;

    public void installUI(JComponent c) {
        super.installUI(c);
        this.falseButton_ = new FalseButton();
        this.falseButton_.setRenderer(this.comboBox.getRenderer());
        if (PlatformUtilities.isMacintosh()) {
            Object sv = this.comboBox.getClientProperty("JComponent.sizeVariant");
            if (sv != null) {
                this.falseButton_.putClientProperty("JComponent.sizeVariant", (String)sv);
                if (this.popup != null) {
                    GissComboPopup gcp = (GissComboPopup)this.popup;
                    gcp.setFont(this.falseButton_.getFont());
                    gcp.putClientProperty("JComponent.sizeVariant", (String)sv);
                }
            }
            this.comboBox.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    String pname = e.getPropertyName();
                    if (pname.equals("JComponent.sizeVariant")) {
                        GissComboBoxUI.this.falseButton_.putClientProperty(pname, e.getNewValue());
                        GissComboPopup gcp = (GissComboPopup)GissComboBoxUI.this.popup;
                        gcp.setFont(GissComboBoxUI.this.falseButton_.getFont());
                        gcp.putClientProperty("JComponent.sizeVariant", e.getNewValue());
                    }
                }
            });
        }
        this.comboBox.addAncestorListener(new FocusAttacher());
        this.comboBox.addMouseListener(new FocusGrabber());
        this.comboBox.setKeySelectionManager(new GCBKeySelectionManager());
        Long l = (Long)UIManager.get("ComboBox.timeFactor");
        timeFactor = l == null ? 1000L : l;
    }

    private MouseListener createButtonListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (GissComboBoxUI.this.comboBox.isEnabled()) {
                    GissComboBoxUI.this.comboBox.grabFocus();
                }
            }
        };
    }

    protected ComboPopup createPopup() {
        GissComboPopup gcp = new GissComboPopup(this.comboBox);
        return gcp;
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addPopupMenuListener(this.popupMenuListener_);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenuListener_ = null;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                GissComboBoxUI.this.arrowButton.getModel().setPressed(true);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GissComboBoxUI.this.arrowButton.getModel().setPressed(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    private ButtonModel createButtonModel() {
        return new DefaultButtonModel(){

            public boolean isPressed() {
                return super.isPressed() || GissComboBoxUI.this.isPopupVisible(GissComboBoxUI.this.comboBox);
            }
        };
    }

    protected ListCellRenderer createRenderer() {
        return new GissComboBoxRenderer();
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.falseButton_.getMinimumSize();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.falseButton_.getPreferredSize();
    }

    protected Dimension getDefaultSize() {
        return new Dimension(100, this.falseButton_.getPreferredSize().height);
    }

    public void paint(Graphics g, JComponent c) {
        GuiUtilities.updateGraphicsIfDisabled((Graphics2D)g, c);
        this.falseButton_.setRenderer(this.comboBox.getRenderer());
        this.falseButton_.paint(g);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected Dimension getDisplaySize() {
        int maxWidth = this.comboBox.getPrototypeDisplayValue() != null ? this.getItemDisplayWidth(this.comboBox.getPrototypeDisplayValue()) : (this.comboBox.getItemCount() > 0 ? this.getMaxComboBoxModelDisplayWidth() : this.getDefaultSize().width);
        Insets ins = this.falseButton_.getInsets();
        return new Dimension(maxWidth += ins.left + ins.right, this.falseButton_.getPreferredSize().height);
    }

    private int getMaxComboBoxModelDisplayWidth() {
        int maxWidth = 0;
        int isize = this.comboBox.getModel().getSize();
        for (int i = 0; i < isize; ++i) {
            int itemWidth = this.getItemDisplayWidth(this.comboBox.getModel().getElementAt(i));
            maxWidth = Math.max(maxWidth, itemWidth);
        }
        return maxWidth;
    }

    private int getItemDisplayWidth(Object item) {
        assert (item != null) : "The given object cannot be null";
        String text = item.toString();
        ListCellRenderer lcr = this.comboBox.getRenderer();
        if (lcr instanceof GissComboBoxRenderer) {
            GissComboBoxRenderer gcbr = (GissComboBoxRenderer)lcr;
            gcbr.setText(text);
            gcbr.setFont(this.falseButton_.getFont());
            Dimension d = gcbr.getPreferredSize();
            return d.width;
        }
        FontMetrics fm = this.comboBox.getFontMetrics(this.comboBox.getFont());
        return fm.stringWidth(text) + 64;
    }

    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(GissComboBoxUI.this.falseButton_.getPreferredSize());
            }

            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(GissComboBoxUI.this.falseButton_.getPreferredSize());
            }

            public void layoutContainer(Container parent) {
                GissComboBoxUI.this.falseButton_.setSize(parent.getSize());
                GissComboBoxUI.this.falseButton_.doLayout();
            }
        };
    }

    class GCBKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private long lastTime = 0L;
        private long time = 0L;
        private String prefix = "";
        private String typedString = "";

        GCBKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            if (this.lastTime == 0L) {
                this.prefix = "";
                this.typedString = "";
            }
            this.time = System.currentTimeMillis();
            this.typedString = this.time - this.lastTime < timeFactor ? this.typedString + aKey : "" + aKey;
            int length = this.typedString.length();
            this.lastTime = this.time;
            int result = -1;
            int isize = aModel.getSize();
            for (int i = 0; i < isize; ++i) {
                Object o = aModel.getElementAt(i);
                String s = o.toString();
                String ss = s.length() > length ? s.substring(0, length) : s;
                int cc = ss.compareToIgnoreCase(this.typedString);
                if (cc != 0) continue;
                result = i;
                break;
            }
            if (result < 0) {
                return result;
            }
            if (GissComboBoxUI.this.popup.isVisible()) {
                ((GissComboPopup)GissComboBoxUI.this.popup).highlight(result);
            } else {
                ((GissComboPopup)GissComboBoxUI.this.popup).show(result);
            }
            return -1;
        }
    }

    class FocusAdapter
    extends WindowAdapter {
        FocusAdapter() {
        }

        public void windowDeactivated(WindowEvent e) {
            this.hidePopupMenu();
        }

        public void windowIconified(WindowEvent e) {
            this.hidePopupMenu();
        }

        public void windowLostFocus(WindowEvent e) {
            this.hidePopupMenu();
        }

        private void hidePopupMenu() {
            if (GissComboBoxUI.this.popup.isVisible()) {
                ((GissComboPopup)GissComboBoxUI.this.popup).hide();
            }
        }
    }

    class FocusAttacher
    implements AncestorListener {
        FocusAttacher() {
        }

        public void ancestorAdded(AncestorEvent e) {
            Window w = GuiUtilities.getParentWindow(GissComboBoxUI.this.comboBox);
            if (w != null) {
                w.addWindowListener(new FocusAdapter());
            }
        }

        public void ancestorMoved(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
        }
    }

    class FocusGrabber
    extends MouseAdapter {
        FocusGrabber() {
        }

        public void mousePressed(MouseEvent e) {
            if (GissComboBoxUI.this.comboBox.isEnabled()) {
                GissComboBoxUI.this.comboBox.grabFocus();
            }
        }
    }

    class FalseButton
    extends JComboBox {
        FalseButton() {
            super(GissComboBoxUI.this.comboBox.getModel());
            this.setDoubleBuffered(false);
            this.setOpaque(false);
        }

        public boolean isFocusOwner() {
            if (GissComboBoxUI.this.popup == null) {
                return false;
            }
            return GissComboBoxUI.this.comboBox.isFocusOwner();
        }

        public boolean hasFocus() {
            return this.isFocusOwner();
        }
    }
}

