/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.plaf;

import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class GissComboBoxRenderer
extends JComponent
implements ListCellRenderer {
    protected static final int GAP = 6;
    private static Icon checkIcon_;
    private static Icon invertIcon_;
    protected static int iconWidth_;
    protected static int iconHeight_;
    protected String text_;
    protected boolean isSelected_;
    protected boolean hasFocus_;
    protected boolean isOffset_;
    protected int prefWidth_;
    protected int prefHeight_;
    protected int lineHeight_;
    protected int lineAscent_;
    protected boolean measured_;
    protected boolean paintCheckIconError_;

    public GissComboBoxRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.setOpaque(false);
        if (checkIcon_ == null && !this.paintCheckIconError_) {
            checkIcon_ = UIManager.getIcon("CheckBoxMenuItem.checkIcon");
            int w = checkIcon_.getIconWidth();
            int h = checkIcon_.getIconHeight();
            int isize = w * h;
            try {
                BufferedImage bi = new BufferedImage(w, h, 2);
                BufferedImage bix = new BufferedImage(w, h, 2);
                Graphics2D g2d = bi.createGraphics();
                checkIcon_.paintIcon(null, g2d, 0, 0);
                int[] pixels = bi.getRGB(0, 0, w, h, null, 0, w);
                for (int i = 0; i < isize; ++i) {
                    int rgb = pixels[i];
                    int a = rgb >> 24 & 0xFF;
                    int r = 255;
                    int g = 255;
                    int b = 255;
                    pixels[i] = a << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                }
                bix.setRGB(0, 0, w, h, pixels, 0, w);
                invertIcon_ = new ImageIcon(bix);
                g2d.dispose();
                iconWidth_ = w;
                iconHeight_ = h;
            }
            catch (Exception exc) {
                checkIcon_ = null;
                invertIcon_ = null;
                iconWidth_ = 11;
                iconHeight_ = 11;
                this.paintCheckIconError_ = true;
            }
        }
    }

    public void setText(String s) {
        this.text_ = s;
        this.measured_ = false;
        this.repaint();
    }

    public void setOffset(boolean b) {
        this.isOffset_ = b;
        this.measured_ = false;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.measured_ = false;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        Insets ins = this.getInsets();
        return new Dimension(this.prefWidth_ + ins.left + ins.right, this.prefHeight_ + ins.top + ins.bottom);
    }

    public void paintComponent(Graphics g) {
        if (!this.measured_) {
            this.measure();
        }
        Graphics2D g2d = (Graphics2D)g.create();
        Insets ins = this.getInsets();
        int contentX = ins.left;
        if (this.isOffset_) {
            contentX += 2 + iconWidth_ + 6;
        }
        this.paintBackground(g2d);
        this.paintCheckIcon(g2d);
        this.paintContent(g2d, contentX);
        g2d.dispose();
    }

    protected void paintBackground(Graphics2D g2d) {
        Dimension size = this.getSize();
        if (this.hasFocus_) {
            if (PlatformUtilities.isMacintosh()) {
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, new Color(104, 124, 237), 0.0f, size.height, new Color(51, 67, 228));
                g2d.setPaint(paint);
                g2d.fillRect(0, 0, size.width, size.height);
            } else {
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, size.width, size.height);
            }
        }
    }

    protected void paintCheckIcon(Graphics2D g2d) {
        if (!this.isSelected_) {
            return;
        }
        Dimension size = this.getSize();
        Insets ins = this.getInsets();
        int x = ins.left + 2;
        if (!this.paintCheckIconError_ && checkIcon_ != null && invertIcon_ != null) {
            try {
                int y = (size.height - iconHeight_) / 2;
                if (this.hasFocus_) {
                    invertIcon_.paintIcon(this, g2d, x, y);
                } else {
                    checkIcon_.paintIcon(this, g2d, x, y);
                }
            }
            catch (Exception exc) {
                this.paintCheckIconError_ = true;
            }
        }
        if (this.paintCheckIconError_) {
            g2d.setColor(this.getForeground());
            int xx = x + 1;
            int yy = (size.height - iconHeight_) / 2 + 1;
            g2d.drawLine(xx + 7, yy + 1, xx + 7, yy + 3);
            g2d.drawLine(xx + 6, yy + 2, xx + 6, yy + 4);
            g2d.drawLine(xx + 5, yy + 3, xx + 5, yy + 5);
            g2d.drawLine(xx + 4, yy + 4, xx + 4, yy + 6);
            g2d.drawLine(xx + 3, yy + 5, xx + 3, yy + 7);
            g2d.drawLine(xx + 2, yy + 4, xx + 2, yy + 6);
            g2d.drawLine(xx + 1, yy + 3, xx + 1, yy + 5);
        }
    }

    protected void paintContent(Graphics2D g2d, int xOffset) {
        Dimension size = this.getSize();
        g2d.setColor(this.getForeground());
        g2d.drawString(this.text_, xOffset, (size.height - this.lineHeight_) / 2 + this.lineAscent_);
    }

    protected synchronized void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.lineHeight_ = fm.getHeight();
        this.lineAscent_ = fm.getAscent();
        this.prefWidth_ = fm.stringWidth(this.text_);
        this.prefHeight_ = this.lineHeight_ + 1;
        if (this.isOffset_) {
            this.prefWidth_ += 2 + iconWidth_ + 6;
        }
        this.measured_ = true;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.isSelected_ = isSelected && index > -1;
        this.hasFocus_ = cellHasFocus;
        this.setOffset(index > -1);
        if (cellHasFocus) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value == null) {
            this.setText(" ");
        } else {
            this.setText(value.toString());
        }
        this.measured_ = false;
        return this;
    }
}

