/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.panel;

import gov.nasa.giss.gui.border.CheckBoxBorder;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckBoxBorderPanel
extends JPanel {
    private JCheckBox checkbox_;
    private JPanel content_;

    public CheckBoxBorderPanel(JCheckBox jcb) {
        this(jcb, null);
    }

    public CheckBoxBorderPanel(JCheckBox checkbox, JPanel content) {
        if (checkbox == null) {
            throw new IllegalArgumentException("Checkbox cannot be null.");
        }
        this.checkbox_ = checkbox;
        this.content_ = content == null ? new JPanel() : content;
        this.setBorder(new CheckBoxBorder(checkbox));
        this.setLayout(null);
        super.add(this.checkbox_);
        super.add(this.content_);
    }

    public JCheckBox getCheckBox() {
        return this.checkbox_;
    }

    public JPanel getContentPanel() {
        return this.content_;
    }

    public void validate() {
        Insets ins = this.getInsets();
        this.content_.setBounds(ins.left, ins.top, this.getSize().width - ins.left - ins.right, this.getSize().height - ins.top - ins.bottom);
        super.validate();
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(this.content_.getPreferredSize().width + ins.left + ins.right, this.content_.getPreferredSize().height + ins.top + ins.bottom);
    }
}

