/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.menu;

import gov.nasa.giss.gui.menu.GissCheckBoxMenuItem;
import gov.nasa.giss.gui.menu.GissMenuItem;
import gov.nasa.giss.gui.menu.GissRadioButtonMenuItem;
import gov.nasa.giss.util.PlatformUtilities;
import gov.nasa.giss.xml.GissPropertyList;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GissMenu
extends JMenu {
    protected GissPropertyList menuProperties_;

    public GissMenu() {
    }

    public GissMenu(Action a) {
        super(a);
    }

    public GissMenu(String text, String name) {
        super(text);
        this.setName(name);
    }

    public GissMenu(GissPropertyList plist) {
        this.setProperties(plist);
    }

    public GissMenu(GissPropertyList plist, String name) {
        this(plist);
        this.setText(this.menuProperties_.getString(name));
        this.setName(name);
    }

    public void setProperties(GissPropertyList props) {
        this.menuProperties_ = props;
    }

    protected static GissMenuItem makeItem(String name, String text, String ksdesc, AbstractAction a) {
        if (text == null) {
            throw new IllegalArgumentException("Menu item text required");
        }
        KeyStroke ks = null;
        GissMenuItem mi = new GissMenuItem(a);
        mi.setText(text);
        if (name != null) {
            mi.setName(name);
        } else {
            mi.setName("_" + text);
        }
        if (ksdesc != null && (ks = KeyStroke.getKeyStroke(ksdesc)) != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    protected GissMenuItem makeItemFromProperties(String pname, AbstractAction a) {
        if (this.menuProperties_ == null) {
            throw new IllegalArgumentException("Properties were not specified");
        }
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            throw new IllegalArgumentException("No properties item by that name");
        }
        GissMenuItem mi = new GissMenuItem(a);
        mi.setName(pname);
        mi.setText(text);
        KeyStroke ks = this.makeKeystrokeFromProperties(pname);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    protected GissCheckBoxMenuItem makeCheckBoxItem(String text, AbstractAction a) {
        GissCheckBoxMenuItem mi = GissCheckBoxMenuItem.createItem(text, a);
        mi.setName("_" + text);
        return mi;
    }

    protected GissCheckBoxMenuItem makeCheckBoxItemFromProperties(String pname, AbstractAction a) {
        if (this.menuProperties_ == null) {
            throw new IllegalArgumentException("Properties have not specified");
        }
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            throw new IllegalArgumentException("No properties item by that name");
        }
        GissCheckBoxMenuItem mi = GissCheckBoxMenuItem.createItem(text, a);
        mi.setName(pname);
        KeyStroke ks = this.makeKeystrokeFromProperties(pname);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    protected static GissRadioButtonMenuItem makeRadioButtonItem(String text, AbstractAction a) {
        GissRadioButtonMenuItem mi = GissRadioButtonMenuItem.createItem(text, a);
        mi.setName("_" + text);
        return mi;
    }

    protected GissRadioButtonMenuItem makeRadioButtonItemFromProperties(String pname, AbstractAction a) {
        if (this.menuProperties_ == null) {
            throw new IllegalArgumentException("Properties have not been specified");
        }
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            throw new IllegalArgumentException("No property by that name");
        }
        GissRadioButtonMenuItem mi = GissRadioButtonMenuItem.createItem(text, a);
        mi.setName(pname);
        KeyStroke ks = this.makeKeystrokeFromProperties(pname);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    private KeyStroke makeKeystrokeFromProperties(String pname) {
        String desc;
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            return null;
        }
        String string = desc = PlatformUtilities.isMacintosh() ? this.menuProperties_.getAttribute(pname, "mackeystroke") : this.menuProperties_.getAttribute(pname, "keystroke");
        if (desc == null) {
            return null;
        }
        return KeyStroke.getKeyStroke(desc);
    }

    public JMenuItem getItemByName(String itemName) {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            JMenuItem mi;
            Component c = this.getMenuComponent(i);
            if (c == null || !(c instanceof JMenuItem) || (mi = (JMenuItem)c).getName() == null || !mi.getName().equals(itemName)) continue;
            return mi;
        }
        return null;
    }

    public JMenuItem getItemByText(String itext) {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            JMenuItem mi;
            Component c = this.getMenuComponent(i);
            if (c == null || !(c instanceof JMenuItem) || (mi = (JMenuItem)c).getText() == null || !mi.getText().equals(itext)) continue;
            return mi;
        }
        return null;
    }

    public Action getItemActionByName(String itemName) {
        JMenuItem jmi = this.getItemByName(itemName);
        if (jmi == null) {
            return null;
        }
        return jmi.getAction();
    }

    public void refresh() {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            Component c = this.getMenuComponent(i);
            if (c == null || !(c instanceof JMenuItem) || !(c instanceof GissMenu)) continue;
            ((GissMenu)c).refresh();
        }
        this.setSize(this.getPreferredSize());
    }
}

